/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.engine;

import java.io.IOException;
import java.io.InputStream;

class SkippingInputStream
extends InputStream {
    private final InputStream delegate;
    private final long skipBytes;
    private boolean hasSkipped;

    public SkippingInputStream(InputStream delegate, long skipBytes) {
        this.delegate = delegate;
        this.skipBytes = skipBytes;
    }

    private void ensureSkipped() throws IOException {
        if (!this.hasSkipped) {
            this.delegate.skipNBytes(this.skipBytes);
            this.hasSkipped = true;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureSkipped();
        return this.delegate.skip(n);
    }

    @Override
    public int read() throws IOException {
        this.ensureSkipped();
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureSkipped();
        return this.delegate.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

