/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.engine;

import java.io.IOException;
import java.io.InputStream;

class ZeroPrefixedInputStream
extends InputStream {
    private final InputStream delegate;
    private long prefixBytes;

    public ZeroPrefixedInputStream(InputStream delegate, long prefixBytes) {
        this.delegate = delegate;
        this.prefixBytes = prefixBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (n <= this.prefixBytes) {
            this.prefixBytes -= n;
            return n;
        }
        if (this.prefixBytes > 0L) {
            n -= this.prefixBytes;
            try {
                long l = this.prefixBytes + this.delegate.skip(n);
                return l;
            }
            finally {
                this.prefixBytes = 0L;
            }
        }
        return this.delegate.skip(n);
    }

    @Override
    public int read() throws IOException {
        if (this.prefixBytes > 0L) {
            --this.prefixBytes;
            return 0;
        }
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.prefixBytes > 0L) {
            return super.read(b, off, len);
        }
        return this.delegate.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        if (this.prefixBytes > 0L) {
            return (int)Math.max(this.prefixBytes, Integer.MAX_VALUE);
        }
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

