/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.keys;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import lombok.Generated;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.encryption.keys.DataEncryptionKeyAccessor;
import org.springframework.content.encryption.keys.StoredDataEncryptionKey;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;

public class ContentPropertyDataEncryptionKeyAccessor<S, T extends StoredDataEncryptionKey>
implements DataEncryptionKeyAccessor<S, T> {
    private final String customPropertyName;
    private final ConversionService conversionService;
    private static final TypeDescriptor ENCRYPTED_DEK = new TypeDescriptor(ResolvableType.forClass(StoredDataEncryptionKey.class), null, null);
    private static final TypeDescriptor ENCRYPTED_DEK_COLLECTION = TypeDescriptor.collection(Collection.class, (TypeDescriptor)ENCRYPTED_DEK);

    @Override
    public Collection<T> findKeys(S entity, ContentProperty contentProperty) {
        Object propertyValue = contentProperty.getCustomProperty(entity, this.customPropertyName);
        return (Collection)this.conversionService.convert(propertyValue, ENCRYPTED_DEK_COLLECTION);
    }

    @Override
    public S clearKeys(S entity, ContentProperty contentProperty) {
        contentProperty.setCustomProperty(entity, this.customPropertyName, null);
        return entity;
    }

    @Override
    public S setKeys(S entity, ContentProperty contentProperty, Collection<T> newKeys) {
        String propertyPath = contentProperty.getCustomPropertyPropertyPath(this.customPropertyName);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entity);
        PropertyDescriptor descriptor = beanWrapper.getPropertyDescriptor(propertyPath);
        TypeDescriptor typeDescriptor = new TypeDescriptor(ResolvableType.forMethodParameter((Method)descriptor.getWriteMethod(), (int)0), null, descriptor.getWriteMethod().getAnnotations());
        TypeDescriptor keyType = newKeys.stream().findFirst().map(TypeDescriptor::forObject).orElse(ENCRYPTED_DEK);
        Object newValue = this.conversionService.convert(newKeys, TypeDescriptor.collection(newKeys.getClass(), (TypeDescriptor)keyType), typeDescriptor);
        contentProperty.setCustomProperty(entity, this.customPropertyName, newValue);
        return entity;
    }

    @Generated
    public ContentPropertyDataEncryptionKeyAccessor(String customPropertyName, ConversionService conversionService) {
        this.customPropertyName = customPropertyName;
        this.conversionService = conversionService;
    }
}

