/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.keys.converter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class ByteArrayToListConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getObjectType() != byte[].class) {
            return false;
        }
        if (!targetType.isCollection()) {
            return false;
        }
        return this.conversionService.canConvert(sourceType, targetType.getElementTypeDescriptor());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Set.of(new GenericConverter.ConvertiblePair(byte[].class, Collection.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        ArrayList<Object> list = new ArrayList<Object>();
        ByteBuffer bb = ByteBuffer.wrap((byte[])source);
        if (bb.getChar() != 'L') {
            return null;
        }
        int length = bb.getInt();
        for (int i = 0; i < length; ++i) {
            int itemSize = bb.getInt();
            byte[] item = new byte[itemSize];
            bb.get(item);
            list.add(this.conversionService.convert((Object)item, targetType.getElementTypeDescriptor()));
        }
        return list;
    }

    @Generated
    public ByteArrayToListConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

