/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.keys.converter;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

class ByteBufferCodec<D, B> {
    private static final Map<Class<?>, BytesConverter<?>> CONVERTERS = Map.of(byte[].class, new BytesConverter<byte[]>(b -> ((byte[])b).length, ByteBuffer::put, (bb, len) -> {
        byte[] data = new byte[len.intValue()];
        bb.get(data);
        return data;
    }), String.class, new BytesConverter<String>(String::length, (bb, s) -> bb.put(s.getBytes(StandardCharsets.UTF_8)), (bb, len) -> {
        byte[] data = new byte[len.intValue()];
        bb.get(data);
        return new String(data, StandardCharsets.UTF_8);
    }));
    private final char marker;
    private final List<Field<D, B, ?>> fields;
    private final Supplier<B> builderCreator;
    private final Function<B, D> builderFinalizer;

    private static BytesConverter<Object> getConverter(Field<?, ?, ?> field) {
        BytesConverter<Object> converter = CONVERTERS.get(field.type());
        if (converter == null) {
            throw new IllegalArgumentException("Can not convert " + String.valueOf(field.type()));
        }
        return converter;
    }

    public byte[] encode(D object) {
        int fieldLength = this.fields.stream().mapToInt(field -> ByteBufferCodec.getConverter(field).length(field.get(object)) + 4).sum();
        ByteBuffer bb = ByteBuffer.allocate(6 + fieldLength);
        bb.putChar(this.marker);
        bb.putInt(this.fields.size());
        for (Field<D, B, ?> field2 : this.fields) {
            BytesConverter<Object> converter = ByteBufferCodec.getConverter(field2);
            converter.write(bb, field2.get(object));
        }
        return bb.array();
    }

    public D decode(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        char foundMarker = bb.getChar();
        if (foundMarker != this.marker) {
            return null;
        }
        int fieldLength = bb.getInt();
        B builder = this.builderCreator.get();
        for (int i = 0; i < fieldLength; ++i) {
            Field<D, B, ?> field = this.fields.get(i);
            BytesConverter<Object> converter = ByteBufferCodec.getConverter(field);
            builder = field.with(builder, converter.read(bb));
        }
        return this.builderFinalizer.apply(builder);
    }

    @Generated
    public ByteBufferCodec(char marker, List<Field<D, B, ?>> fields, Supplier<B> builderCreator, Function<B, D> builderFinalizer) {
        this.marker = marker;
        this.fields = fields;
        this.builderCreator = builderCreator;
        this.builderFinalizer = builderFinalizer;
    }

    public record Field<D, B, T>(Class<T> type, Function<D, T> getter, BiFunction<B, T, B> builderSetter) {
        T get(D data) {
            return this.getter.apply(data);
        }

        B with(B builder, T item) {
            return this.builderSetter.apply(builder, item);
        }
    }

    private static class BytesConverter<T> {
        private final Function<T, Integer> length;
        private final BiConsumer<ByteBuffer, T> write;
        private final BiFunction<ByteBuffer, Integer, T> read;

        public int length(T value) {
            return this.length.apply(value);
        }

        public T read(ByteBuffer bb) {
            int len = bb.getInt();
            int startPos = bb.position();
            T result = this.read.apply(bb, len);
            int endPos = bb.position();
            int readBytes = endPos - startPos;
            if (len != readBytes) {
                throw new IllegalArgumentException("Read function did not read declared number of bytes (declared %d; read %d)".formatted(len, readBytes));
            }
            return result;
        }

        public void write(ByteBuffer bb, T value) {
            Integer len = this.length.apply(value);
            bb.putInt(len);
            int startPos = bb.position();
            this.write.accept(bb, (ByteBuffer)value);
            int endPos = bb.position();
            int writtenBytes = endPos - startPos;
            if (writtenBytes != len) {
                throw new IllegalStateException("Write function did not write requested number of bytes (requested %d; written %d)".formatted(len, writtenBytes));
            }
        }

        @Generated
        public BytesConverter(Function<T, Integer> length, BiConsumer<ByteBuffer, T> write, BiFunction<ByteBuffer, Integer, T> read) {
            this.length = length;
            this.write = write;
            this.read = read;
        }
    }
}

