/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.encryption.keys.converter;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class ListToByteArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (targetType.getObjectType() != byte[].class) {
            return false;
        }
        if (!sourceType.isCollection()) {
            return false;
        }
        return this.conversionService.canConvert(sourceType.getElementTypeDescriptor(), targetType);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Set.of(new GenericConverter.ConvertiblePair(Collection.class, byte[].class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        List<Object> converted = ((List)source).stream().map(item -> this.conversionService.convert(item, sourceType.getElementTypeDescriptor(), targetType)).toList();
        int convertedTotalSize = converted.stream().mapToInt(b -> ((byte[])b).length).sum();
        ByteBuffer bb = ByteBuffer.allocate(6 + converted.size() * 4 + convertedTotalSize);
        bb.putChar('L');
        bb.putInt(converted.size());
        for (byte[] byArray : converted) {
            bb.putInt(byArray.length);
            bb.put(byArray);
        }
        return bb.array();
    }

    @Generated
    public ListToByteArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

