/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import internal.org.springframework.content.fragments.DecryptedResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.encryption.engine.ContentEncryptionEngine;
import org.springframework.content.encryption.keys.DataEncryptionKeyAccessor;
import org.springframework.content.encryption.keys.DataEncryptionKeyWrapper;
import org.springframework.content.encryption.keys.StoredDataEncryptionKey;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

class ContentCryptoService<S, DEK extends StoredDataEncryptionKey> {
    private final MappingContext mappingContext;
    private final DataEncryptionKeyAccessor<S, DEK> dataEncryptionKeyAccessor;
    private final List<DataEncryptionKeyWrapper<DEK>> dataEncryptionKeyWrappers;
    private final ContentEncryptionEngine encryptionEngine;
    private static final Pattern RANGE_PATTERN = Pattern.compile("\\Abytes=(?<firstPos>[0-9]*)-(?<lastPos>[0-9]*)\\Z");

    public S encrypt(S entity, PropertyPath propertyPath, InputStream plainText, BiFunction<S, InputStream, S> contentSetter) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)plainText, (String)"plainText not set");
        ContentProperty contentProperty = this.resolveContentPropertyRequired(entity, propertyPath);
        ContentEncryptionEngine.EncryptionParameters encryptionParameters = this.encryptionEngine.createNewParameters();
        List<StoredDataEncryptionKey> encryptedDeks = this.dataEncryptionKeyWrappers.stream().map(wrapper -> wrapper.wrapEncryptionKey(encryptionParameters)).toList();
        InputStream encryptedStream = this.encryptionEngine.encrypt(plainText, encryptionParameters);
        S newEntity = contentSetter.apply(entity, encryptedStream);
        return this.dataEncryptionKeyAccessor.setKeys(newEntity, contentProperty, encryptedDeks);
    }

    public Resource decrypt(S entity, PropertyPath propertyPath, GetResourceParams getResourceParams, Supplier<Resource> contentGetter) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        ContentProperty contentProperty = this.resolveContentPropertyRequired(entity, propertyPath);
        Collection<DEK> encryptedDeks = this.dataEncryptionKeyAccessor.findKeys(entity, contentProperty);
        Resource resource = contentGetter.get();
        if (encryptedDeks == null) {
            return resource;
        }
        ContentEncryptionEngine.EncryptionParameters encryptionParameters = this.decryptEncryptionParameters(encryptedDeks);
        if (encryptionParameters == null) {
            throw new StoreAccessException(String.format("Content property %s can not be decrypted".formatted(propertyPath.getName()), new Object[0]));
        }
        ContentEncryptionEngine.InputStreamRequestParameters requestParams = ContentEncryptionEngine.InputStreamRequestParameters.full();
        try {
            if (getResourceParams != null) {
                requestParams = ContentCryptoService.parseRangePattern(getResourceParams.getRange(), resource);
            }
        }
        catch (IOException ex) {
            throw new StoreAccessException(String.format("Content property %s can not be accessed".formatted(propertyPath.getName()), new Object[0]), (Throwable)ex);
        }
        ContentEncryptionEngine.InputStreamRequestParameters finalRequestParams = requestParams;
        return new DecryptedResource(() -> this.encryptionEngine.decrypt(params -> {
            if (resource instanceof RangeableResource) {
                RangeableResource rr = (RangeableResource)resource;
                rr.setRange(ContentCryptoService.constructRangePattern(params));
            }
            try {
                return resource.getInputStream();
            }
            catch (IOException ex) {
                throw new StoreAccessException(String.format("Content property %s can not be accessed".formatted(propertyPath.getName()), new Object[0]), (Throwable)ex);
            }
        }, encryptionParameters, finalRequestParams), resource);
    }

    public S clearKeys(S entity, PropertyPath propertyPath) {
        return this.dataEncryptionKeyAccessor.clearKeys(entity, this.resolveContentPropertyRequired(entity, propertyPath));
    }

    private ContentProperty resolveContentPropertyRequired(S entity, PropertyPath propertyPath) {
        ContentProperty contentProperty = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        return contentProperty;
    }

    private ContentEncryptionEngine.EncryptionParameters decryptEncryptionParameters(Collection<DEK> encryptedDeks) {
        for (DataEncryptionKeyWrapper<DEK> wrapper : this.dataEncryptionKeyWrappers) {
            for (StoredDataEncryptionKey encryptedDek : encryptedDeks) {
                if (!wrapper.supports(encryptedDek)) continue;
                return wrapper.unwrapEncryptionKey(encryptedDek);
            }
        }
        return null;
    }

    private static ContentEncryptionEngine.InputStreamRequestParameters parseRangePattern(String range, Resource resource) throws IOException {
        if (range == null || range.isEmpty()) {
            return ContentEncryptionEngine.InputStreamRequestParameters.full();
        }
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (matcher.matches()) {
            String firstPosStr = matcher.group("firstPos");
            String lastPosStr = matcher.group("lastPos");
            if (firstPosStr.isEmpty() && lastPosStr.isEmpty()) {
                return ContentEncryptionEngine.InputStreamRequestParameters.full();
            }
            if (firstPosStr.isEmpty()) {
                long contentLength = resource.contentLength();
                return ContentEncryptionEngine.InputStreamRequestParameters.startingFrom(contentLength - Long.parseUnsignedLong(lastPosStr));
            }
            return new ContentEncryptionEngine.InputStreamRequestParameters(Long.parseUnsignedLong(firstPosStr), lastPosStr.isEmpty() ? null : Long.valueOf(Long.parseUnsignedLong(lastPosStr)));
        }
        throw new StoreAccessException(String.format("Range request '%s' is not supported. Only a single byte-range is supported".formatted(range), new Object[0]));
    }

    private static String constructRangePattern(ContentEncryptionEngine.InputStreamRequestParameters parameters) {
        return "bytes=" + parameters.getStartByteOffset() + "-" + Optional.ofNullable(parameters.getEndByteOffset()).map(Long::toUnsignedString).orElse("");
    }

    @Generated
    public ContentCryptoService(MappingContext mappingContext, DataEncryptionKeyAccessor<S, DEK> dataEncryptionKeyAccessor, List<DataEncryptionKeyWrapper<DEK>> dataEncryptionKeyWrappers, ContentEncryptionEngine encryptionEngine) {
        this.mappingContext = mappingContext;
        this.dataEncryptionKeyAccessor = dataEncryptionKeyAccessor;
        this.dataEncryptionKeyWrappers = dataEncryptionKeyWrappers;
        this.encryptionEngine = encryptionEngine;
    }
}

