/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;

class DecryptedResource
extends AbstractResource {
    private final InputStreamSource decryptedInputStreamSource;
    private final Resource originalResource;

    DecryptedResource(InputStreamSource decryptedInputStreamSource, Resource originalResource) {
        this.decryptedInputStreamSource = decryptedInputStreamSource;
        this.originalResource = originalResource;
    }

    public InputStream getInputStream() throws IOException {
        return this.decryptedInputStreamSource.getInputStream();
    }

    public boolean exists() {
        return this.originalResource.exists();
    }

    public long contentLength() throws IOException {
        return this.originalResource.contentLength();
    }

    public long lastModified() throws IOException {
        return this.originalResource.lastModified();
    }

    public String getFilename() {
        return this.originalResource.getFilename();
    }

    public String getDescription() {
        return "Decrypted " + this.originalResource.getDescription();
    }
}

