/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import internal.org.springframework.content.encryption.engine.AesCtrEncryptionEngine;
import internal.org.springframework.content.encryption.keys.ContentPropertyDataEncryptionKeyAccessor;
import internal.org.springframework.content.encryption.keys.UnencryptedSymmetricDataEncryptionKeyWrapper;
import internal.org.springframework.content.encryption.keys.converter.ByteArrayToListConverter;
import internal.org.springframework.content.encryption.keys.converter.EncryptedSymmetricDataEncryptionKeyConverter;
import internal.org.springframework.content.encryption.keys.converter.ListToByteArrayConverter;
import internal.org.springframework.content.encryption.keys.converter.StoredDataEncryptionKeyGenericConverter;
import internal.org.springframework.content.encryption.keys.converter.UnencryptedSymmetricDataEncryptionKeyConverter;
import internal.org.springframework.content.fragments.ContentCryptoService;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.store.Store;
import org.springframework.content.encryption.config.EncryptingContentStoreConfiguration;
import org.springframework.content.encryption.engine.ContentEncryptionEngine;
import org.springframework.content.encryption.keys.DataEncryptionKeyAccessor;
import org.springframework.content.encryption.keys.DataEncryptionKeyWrapper;
import org.springframework.content.encryption.keys.StoredDataEncryptionKey;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.GenericConversionService;

class EncryptingContentStoreConfigurationImpl<S>
implements EncryptingContentStoreConfiguration<S> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptingContentStoreConfigurationImpl.class);
    private DataEncryptionKeyAccessor<S, ? extends StoredDataEncryptionKey> dataEncryptionKeyAccessor;
    private List<DataEncryptionKeyWrapper<? extends StoredDataEncryptionKey>> dataEncryptionKeyWrappers;
    private ContentEncryptionEngine contentEncryptionEngine;
    private final ConfigurableConversionService conversionService = new GenericConversionService();

    EncryptingContentStoreConfigurationImpl() {
        this.conversionService.addConverter((GenericConverter)new ByteArrayToListConverter((ConversionService)this.conversionService));
        this.conversionService.addConverter((GenericConverter)new ListToByteArrayConverter((ConversionService)this.conversionService));
        this.conversionService.addConverter((GenericConverter)new StoredDataEncryptionKeyGenericConverter((ConversionService)this.conversionService));
        this.conversionService.addConverter(byte[].class, StoredDataEncryptionKey.UnencryptedSymmetricDataEncryptionKey.class, UnencryptedSymmetricDataEncryptionKeyConverter::convert);
        this.conversionService.addConverter(StoredDataEncryptionKey.UnencryptedSymmetricDataEncryptionKey.class, byte[].class, UnencryptedSymmetricDataEncryptionKeyConverter::convert);
        this.conversionService.addConverter(byte[].class, StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey.class, EncryptedSymmetricDataEncryptionKeyConverter::convert);
        this.conversionService.addConverter(StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey.class, byte[].class, EncryptedSymmetricDataEncryptionKeyConverter::convert);
    }

    @Override
    public EncryptingContentStoreConfiguration<S> dataEncryptionKeyAccessor(DataEncryptionKeyAccessor<S, ? extends StoredDataEncryptionKey> accessor) {
        this.dataEncryptionKeyAccessor = accessor;
        return this;
    }

    @Override
    public EncryptingContentStoreConfiguration<S> dataEncryptionKeyWrappers(List<DataEncryptionKeyWrapper<? extends StoredDataEncryptionKey>> wrappers) {
        this.dataEncryptionKeyWrappers = List.copyOf(wrappers);
        return this;
    }

    @Override
    public EncryptingContentStoreConfiguration<S> contentEncryptionEngine(ContentEncryptionEngine contentEncryptionEngine) {
        this.contentEncryptionEngine = contentEncryptionEngine;
        return this;
    }

    @Override
    public EncryptingContentStoreConfiguration<S> encryptionKeyContentProperty(String encryptionKeyContentProperty) {
        return this.dataEncryptionKeyAccessor(new ContentPropertyDataEncryptionKeyAccessor(encryptionKeyContentProperty, (ConversionService)this.conversionService));
    }

    @Override
    public EncryptingContentStoreConfiguration<S> unencryptedDataEncryptionKeys() {
        return this.dataEncryptionKeyWrappers(List.of(new UnencryptedSymmetricDataEncryptionKeyWrapper()));
    }

    @Override
    public EncryptingContentStoreConfiguration<S> configureConverters(Consumer<ConverterRegistry> converterConfigurer) {
        converterConfigurer.accept((ConverterRegistry)this.conversionService);
        return this;
    }

    @Override
    public EncryptingContentStoreConfiguration<S> contentEncryptionMethod(EncryptingContentStoreConfiguration.ContentEncryptionMethod contentEncryptionMethod) {
        return this.contentEncryptionEngine(switch (contentEncryptionMethod) {
            default -> throw new IncompatibleClassChangeError();
            case EncryptingContentStoreConfiguration.ContentEncryptionMethod.AES_CTR_128 -> new AesCtrEncryptionEngine(128);
            case EncryptingContentStoreConfiguration.ContentEncryptionMethod.AES_CTR_192 -> new AesCtrEncryptionEngine(192);
            case EncryptingContentStoreConfiguration.ContentEncryptionMethod.AES_CTR_256 -> new AesCtrEncryptionEngine(256);
        });
    }

    ContentCryptoService<S, ?> initializeCryptoService(MappingContext mappingContext, Class<? extends Store<?>> storeClass) {
        if (this.dataEncryptionKeyAccessor == null) {
            this.encryptionKeyContentProperty("encryption");
        }
        if (this.dataEncryptionKeyWrappers == null) {
            log.warn("Data Encryption Keys are NOT encrypted: No DataEncryptionKeyWrapper configured on store {}", storeClass);
            this.unencryptedDataEncryptionKeys();
        }
        if (this.contentEncryptionEngine == null) {
            log.warn("Using AES-CTR-128 as default encryption for store {}", storeClass);
            this.contentEncryptionMethod(EncryptingContentStoreConfiguration.ContentEncryptionMethod.AES_CTR_128);
        }
        if (this.dataEncryptionKeyWrappers.isEmpty()) {
            throw new IllegalStateException("No DataEncryptionKeyWrappers configured on store %s. Refusing to start as encrypted content would be unrecoverable.".formatted(storeClass));
        }
        return new ContentCryptoService<S, StoredDataEncryptionKey>(mappingContext, this.dataEncryptionKeyAccessor, this.dataEncryptionKeyWrappers, this.contentEncryptionEngine);
    }
}

