/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fragments;

import internal.org.springframework.content.fragments.ContentCryptoService;
import internal.org.springframework.content.fragments.EncryptingContentStoreConfigurationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.fragments.ContentStoreAware;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.SetContentParams;
import org.springframework.content.commons.repository.UnsetContentParams;
import org.springframework.content.commons.store.ContentStore;
import org.springframework.content.commons.store.GetResourceParams;
import org.springframework.content.commons.store.SetContentParams;
import org.springframework.content.commons.store.Store;
import org.springframework.content.commons.store.StoreAccessException;
import org.springframework.content.commons.store.UnsetContentParams;
import org.springframework.content.encryption.config.EncryptingContentStoreConfigurer;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class EncryptingContentStoreImpl<S, SID extends Serializable>
implements ContentStore<S, SID>,
org.springframework.content.commons.repository.ContentStore<S, SID>,
ContentStoreAware {
    private final MappingContext mappingContext;
    private ContentCryptoService<S, ?> cryptoService;
    private final List<EncryptingContentStoreConfigurer<S>> configurers;
    private ContentStore<S, SID> storeDelegate;

    @Autowired
    public EncryptingContentStoreImpl(@Autowired(required=false) MappingContext mappingContext, List<EncryptingContentStoreConfigurer<S>> configurers) {
        this.mappingContext = Optional.ofNullable(mappingContext).orElseGet(() -> new MappingContext((CharSequence)"/", (CharSequence)"."));
        this.configurers = configurers;
    }

    public S setContent(S o, InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content) {
        Assert.notNull(this.storeDelegate, (String)"store not set");
        Assert.notNull(this.cryptoService, (String)"cryptoService not set");
        return (S)this.cryptoService.encrypt(entity, propertyPath, content, (e, s) -> this.storeDelegate.setContent(e, propertyPath, s));
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream inputStream, long l) {
        return this.setContent(entity, propertyPath, inputStream, SetContentParams.builder().contentLength(l).build());
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content, org.springframework.content.commons.repository.SetContentParams params) {
        return this.setContent(entity, propertyPath, content, EncryptingContentStoreImpl.convertParams(params));
    }

    public S setContent(S entity, PropertyPath propertyPath, InputStream content, SetContentParams params) {
        Assert.notNull(this.storeDelegate, (String)"store not set");
        Assert.notNull(this.cryptoService, (String)"cryptoService not set");
        return (S)this.cryptoService.encrypt(entity, propertyPath, content, (e, s) -> this.storeDelegate.setContent(e, propertyPath, s, params));
    }

    public S setContent(S o, Resource resource) {
        throw new UnsupportedOperationException();
    }

    public S setContent(S entity, PropertyPath propertyPath, Resource resource) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull((Object)resource, (String)"resource not set");
        Assert.notNull(this.storeDelegate, (String)"store not set");
        Assert.notNull(this.cryptoService, (String)"cryptoService not set");
        try {
            return (S)this.cryptoService.encrypt(entity, propertyPath, resource.getInputStream(), (e, s) -> this.storeDelegate.setContent(e, propertyPath, (Resource)new InputStreamResource(s)));
        }
        catch (IOException e2) {
            throw new StoreAccessException("error encrypting resource", (Throwable)e2);
        }
    }

    public S unsetContent(S o) {
        throw new UnsupportedOperationException();
    }

    public S unsetContent(S entity, PropertyPath propertyPath) {
        return this.unsetContent(entity, propertyPath, org.springframework.content.commons.store.UnsetContentParams.builder().build());
    }

    public S unsetContent(S entity, PropertyPath propertyPath, UnsetContentParams params) {
        return this.unsetContent(entity, propertyPath, EncryptingContentStoreImpl.convertParams(params));
    }

    public S unsetContent(S entity, PropertyPath propertyPath, org.springframework.content.commons.store.UnsetContentParams params) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull(this.storeDelegate, (String)"store not set");
        Assert.notNull(this.cryptoService, (String)"cryptoService not set");
        ContentProperty contentProperty = this.mappingContext.getContentProperty(entity.getClass(), propertyPath.getName());
        if (contentProperty == null) {
            throw new StoreAccessException(String.format("Content property %s does not exist", propertyPath.getName()));
        }
        S newEntity = this.cryptoService.clearKeys(entity, propertyPath);
        return (S)this.storeDelegate.unsetContent(newEntity, propertyPath, params);
    }

    public InputStream getContent(S o) {
        throw new UnsupportedOperationException();
    }

    public InputStream getContent(S entity, PropertyPath propertyPath) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull(this.storeDelegate, (String)"store not set");
        Assert.notNull(this.cryptoService, (String)"cryptoService not set");
        return this.cryptoService.decrypt(entity, propertyPath, null, () -> this.storeDelegate.getResource(entity, propertyPath)).getInputStream();
    }

    public Resource getResource(S o) {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(S entity, PropertyPath propertyPath) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull(this.storeDelegate, (String)"store not set");
        Assert.notNull(this.cryptoService, (String)"cryptoService not set");
        return this.cryptoService.decrypt(entity, propertyPath, null, () -> this.storeDelegate.getResource(entity, propertyPath));
    }

    public Resource getResource(S entity, PropertyPath propertyPath, org.springframework.content.commons.repository.GetResourceParams params) {
        return this.getResource(entity, propertyPath, this.convertParams(params));
    }

    public Resource getResource(S entity, PropertyPath propertyPath, GetResourceParams params) {
        Assert.notNull(entity, (String)"entity not set");
        Assert.notNull((Object)propertyPath, (String)"propertyPath not set");
        Assert.notNull(this.storeDelegate, (String)"store not set");
        Assert.notNull(this.cryptoService, (String)"cryptoService not set");
        return this.cryptoService.decrypt(entity, propertyPath, params, () -> this.storeDelegate.getResource(entity, propertyPath));
    }

    public void associate(S o, SID serializable) {
        throw new UnsupportedOperationException();
    }

    public void associate(S o, PropertyPath propertyPath, SID serializable) {
        throw new UnsupportedOperationException();
    }

    public void unassociate(S o) {
        throw new UnsupportedOperationException();
    }

    public void unassociate(S o, PropertyPath propertyPath) {
        throw new UnsupportedOperationException();
    }

    public Resource getResource(SID id) {
        throw new UnsupportedOperationException();
    }

    public void setDomainClass(Class<?> domainClass) {
    }

    public void setIdClass(Class<?> idClass) {
    }

    public void setContentStore(org.springframework.content.commons.repository.ContentStore store) {
    }

    public void setContentStore(ContentStore store) {
        this.storeDelegate = store;
    }

    public void setStoreInterfaceClass(Class<? extends Store<?>> storeInterfaceClass) {
        this.configure(storeInterfaceClass);
    }

    private void configure(Class<? extends Store<?>> storeInterfaceClass) {
        if (this.configurers == null) {
            return;
        }
        EncryptingContentStoreConfigurationImpl config = new EncryptingContentStoreConfigurationImpl();
        for (EncryptingContentStoreConfigurer configurer : this.configurers) {
            Type[] genericArguments;
            Optional<Type> interfaces = Arrays.stream(configurer.getClass().getGenericInterfaces()).findFirst();
            if (interfaces.isEmpty() || (genericArguments = ((ParameterizedType)interfaces.get()).getActualTypeArguments()).length < 1 || !genericArguments[0].equals(storeInterfaceClass)) continue;
            configurer.configure(config);
        }
        this.cryptoService = config.initializeCryptoService(this.mappingContext, storeInterfaceClass);
    }

    private static org.springframework.content.commons.store.UnsetContentParams convertParams(UnsetContentParams params) {
        return org.springframework.content.commons.store.UnsetContentParams.builder().disposition(EncryptingContentStoreImpl.convertDisposition(params.getDisposition())).build();
    }

    private static UnsetContentParams.Disposition convertDisposition(UnsetContentParams.Disposition disposition) {
        return switch (disposition) {
            default -> throw new IncompatibleClassChangeError();
            case UnsetContentParams.Disposition.Keep -> UnsetContentParams.Disposition.Keep;
            case UnsetContentParams.Disposition.Remove -> UnsetContentParams.Disposition.Remove;
        };
    }

    private GetResourceParams convertParams(org.springframework.content.commons.repository.GetResourceParams params) {
        return GetResourceParams.builder().range(params.getRange()).build();
    }

    private static SetContentParams convertParams(org.springframework.content.commons.repository.SetContentParams params) {
        return SetContentParams.builder().contentLength(params.getContentLength()).disposition(EncryptingContentStoreImpl.convertDisposition(params.getDisposition())).overwriteExistingContent(params.isOverwriteExistingContent()).build();
    }

    private static SetContentParams.ContentDisposition convertDisposition(SetContentParams.ContentDisposition disposition) {
        return switch (disposition) {
            default -> throw new IncompatibleClassChangeError();
            case SetContentParams.ContentDisposition.Overwrite -> SetContentParams.ContentDisposition.Overwrite;
            case SetContentParams.ContentDisposition.CreateNew -> SetContentParams.ContentDisposition.CreateNew;
        };
    }
}

