/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.encryption.engine;

import java.io.InputStream;
import java.util.function.Function;
import javax.crypto.SecretKey;
import lombok.Generated;

public interface ContentEncryptionEngine {
    public EncryptionParameters createNewParameters();

    public InputStream encrypt(InputStream var1, EncryptionParameters var2);

    public InputStream decrypt(Function<InputStreamRequestParameters, InputStream> var1, EncryptionParameters var2, InputStreamRequestParameters var3);

    public static class InputStreamRequestParameters {
        private final long startByteOffset;
        private final Long endByteOffset;

        public static InputStreamRequestParameters full() {
            return InputStreamRequestParameters.startingFrom(0L);
        }

        public static InputStreamRequestParameters startingFrom(long startByteOffset) {
            return new InputStreamRequestParameters(startByteOffset, null);
        }

        @Generated
        public InputStreamRequestParameters(long startByteOffset, Long endByteOffset) {
            this.startByteOffset = startByteOffset;
            this.endByteOffset = endByteOffset;
        }

        @Generated
        public long getStartByteOffset() {
            return this.startByteOffset;
        }

        @Generated
        public Long getEndByteOffset() {
            return this.endByteOffset;
        }
    }

    public static class EncryptionParameters {
        private final SecretKey secretKey;
        private final byte[] initializationVector;

        @Generated
        public SecretKey getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public byte[] getInitializationVector() {
            return this.initializationVector;
        }

        @Generated
        public EncryptionParameters(SecretKey secretKey, byte[] initializationVector) {
            this.secretKey = secretKey;
            this.initializationVector = initializationVector;
        }
    }
}

