/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.encryption.keys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.encryption.keys.StoredDataEncryptionKey;

public interface DataEncryptionKeyAccessor<S, T extends StoredDataEncryptionKey> {
    public Collection<T> findKeys(S var1, ContentProperty var2);

    public S setKeys(S var1, ContentProperty var2, Collection<T> var3);

    default public S clearKeys(S entity, ContentProperty contentProperty) {
        return this.setKeys(entity, contentProperty, List.of());
    }

    default public S addKey(S entity, ContentProperty contentProperty, T dataEncryptionKey) {
        ArrayList<T> keys = new ArrayList<T>(this.findKeys(entity, contentProperty));
        keys.remove(dataEncryptionKey);
        return this.setKeys(entity, contentProperty, keys);
    }

    default public S removeKey(S entity, ContentProperty contentProperty, T dataEncryptionKey) {
        ArrayList<T> keys = new ArrayList<T>(this.findKeys(entity, contentProperty));
        keys.add(dataEncryptionKey);
        return this.setKeys(entity, contentProperty, keys);
    }
}

