/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.encryption.keys;

import java.util.Arrays;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StoredDataEncryptionKey {

    public static final class EncryptedSymmetricDataEncryptionKey
    implements StoredDataEncryptionKey {
        private final String wrappingAlgorithm;
        private final String wrappingKeyId;
        private final String wrappingKeyVersion;
        private final String dataEncryptionAlgorithm;
        private final byte[] encryptedKeyData;
        private final byte[] initializationVector;

        @Generated
        public static EncryptedSymmetricDataEncryptionKeyBuilder builder() {
            return new EncryptedSymmetricDataEncryptionKeyBuilder();
        }

        @Generated
        public EncryptedSymmetricDataEncryptionKey(String wrappingAlgorithm, String wrappingKeyId, String wrappingKeyVersion, String dataEncryptionAlgorithm, byte[] encryptedKeyData, byte[] initializationVector) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            this.wrappingKeyId = wrappingKeyId;
            this.wrappingKeyVersion = wrappingKeyVersion;
            this.dataEncryptionAlgorithm = dataEncryptionAlgorithm;
            this.encryptedKeyData = encryptedKeyData;
            this.initializationVector = initializationVector;
        }

        @Generated
        public String getWrappingAlgorithm() {
            return this.wrappingAlgorithm;
        }

        @Generated
        public String getWrappingKeyId() {
            return this.wrappingKeyId;
        }

        @Generated
        public String getWrappingKeyVersion() {
            return this.wrappingKeyVersion;
        }

        @Generated
        public String getDataEncryptionAlgorithm() {
            return this.dataEncryptionAlgorithm;
        }

        @Generated
        public byte[] getEncryptedKeyData() {
            return this.encryptedKeyData;
        }

        @Generated
        public byte[] getInitializationVector() {
            return this.initializationVector;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncryptedSymmetricDataEncryptionKey)) {
                return false;
            }
            EncryptedSymmetricDataEncryptionKey other = (EncryptedSymmetricDataEncryptionKey)o;
            String this$wrappingAlgorithm = this.getWrappingAlgorithm();
            String other$wrappingAlgorithm = other.getWrappingAlgorithm();
            if (this$wrappingAlgorithm == null ? other$wrappingAlgorithm != null : !this$wrappingAlgorithm.equals(other$wrappingAlgorithm)) {
                return false;
            }
            String this$wrappingKeyId = this.getWrappingKeyId();
            String other$wrappingKeyId = other.getWrappingKeyId();
            if (this$wrappingKeyId == null ? other$wrappingKeyId != null : !this$wrappingKeyId.equals(other$wrappingKeyId)) {
                return false;
            }
            String this$wrappingKeyVersion = this.getWrappingKeyVersion();
            String other$wrappingKeyVersion = other.getWrappingKeyVersion();
            if (this$wrappingKeyVersion == null ? other$wrappingKeyVersion != null : !this$wrappingKeyVersion.equals(other$wrappingKeyVersion)) {
                return false;
            }
            String this$dataEncryptionAlgorithm = this.getDataEncryptionAlgorithm();
            String other$dataEncryptionAlgorithm = other.getDataEncryptionAlgorithm();
            if (this$dataEncryptionAlgorithm == null ? other$dataEncryptionAlgorithm != null : !this$dataEncryptionAlgorithm.equals(other$dataEncryptionAlgorithm)) {
                return false;
            }
            if (!Arrays.equals(this.getEncryptedKeyData(), other.getEncryptedKeyData())) {
                return false;
            }
            return Arrays.equals(this.getInitializationVector(), other.getInitializationVector());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $wrappingAlgorithm = this.getWrappingAlgorithm();
            result = result * 59 + ($wrappingAlgorithm == null ? 43 : $wrappingAlgorithm.hashCode());
            String $wrappingKeyId = this.getWrappingKeyId();
            result = result * 59 + ($wrappingKeyId == null ? 43 : $wrappingKeyId.hashCode());
            String $wrappingKeyVersion = this.getWrappingKeyVersion();
            result = result * 59 + ($wrappingKeyVersion == null ? 43 : $wrappingKeyVersion.hashCode());
            String $dataEncryptionAlgorithm = this.getDataEncryptionAlgorithm();
            result = result * 59 + ($dataEncryptionAlgorithm == null ? 43 : $dataEncryptionAlgorithm.hashCode());
            result = result * 59 + Arrays.hashCode(this.getEncryptedKeyData());
            result = result * 59 + Arrays.hashCode(this.getInitializationVector());
            return result;
        }

        @Generated
        public static class EncryptedSymmetricDataEncryptionKeyBuilder {
            @Generated
            private String wrappingAlgorithm;
            @Generated
            private String wrappingKeyId;
            @Generated
            private String wrappingKeyVersion;
            @Generated
            private String dataEncryptionAlgorithm;
            @Generated
            private byte[] encryptedKeyData;
            @Generated
            private byte[] initializationVector;

            @Generated
            EncryptedSymmetricDataEncryptionKeyBuilder() {
            }

            @Generated
            public EncryptedSymmetricDataEncryptionKeyBuilder wrappingAlgorithm(String wrappingAlgorithm) {
                this.wrappingAlgorithm = wrappingAlgorithm;
                return this;
            }

            @Generated
            public EncryptedSymmetricDataEncryptionKeyBuilder wrappingKeyId(String wrappingKeyId) {
                this.wrappingKeyId = wrappingKeyId;
                return this;
            }

            @Generated
            public EncryptedSymmetricDataEncryptionKeyBuilder wrappingKeyVersion(String wrappingKeyVersion) {
                this.wrappingKeyVersion = wrappingKeyVersion;
                return this;
            }

            @Generated
            public EncryptedSymmetricDataEncryptionKeyBuilder dataEncryptionAlgorithm(String dataEncryptionAlgorithm) {
                this.dataEncryptionAlgorithm = dataEncryptionAlgorithm;
                return this;
            }

            @Generated
            public EncryptedSymmetricDataEncryptionKeyBuilder encryptedKeyData(byte[] encryptedKeyData) {
                this.encryptedKeyData = encryptedKeyData;
                return this;
            }

            @Generated
            public EncryptedSymmetricDataEncryptionKeyBuilder initializationVector(byte[] initializationVector) {
                this.initializationVector = initializationVector;
                return this;
            }

            @Generated
            public EncryptedSymmetricDataEncryptionKey build() {
                return new EncryptedSymmetricDataEncryptionKey(this.wrappingAlgorithm, this.wrappingKeyId, this.wrappingKeyVersion, this.dataEncryptionAlgorithm, this.encryptedKeyData, this.initializationVector);
            }

            @Generated
            public String toString() {
                return "StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey.EncryptedSymmetricDataEncryptionKeyBuilder(wrappingAlgorithm=" + this.wrappingAlgorithm + ", wrappingKeyId=" + this.wrappingKeyId + ", wrappingKeyVersion=" + this.wrappingKeyVersion + ", dataEncryptionAlgorithm=" + this.dataEncryptionAlgorithm + ", encryptedKeyData=" + Arrays.toString(this.encryptedKeyData) + ", initializationVector=" + Arrays.toString(this.initializationVector) + ")";
            }
        }
    }

    public static final class UnencryptedSymmetricDataEncryptionKey
    implements StoredDataEncryptionKey {
        private final String algorithm;
        private final byte[] keyData;
        private final byte[] initializationVector;

        @Generated
        public static UnencryptedSymmetricDataEncryptionKeyBuilder builder() {
            return new UnencryptedSymmetricDataEncryptionKeyBuilder();
        }

        @Generated
        public UnencryptedSymmetricDataEncryptionKey(String algorithm, byte[] keyData, byte[] initializationVector) {
            this.algorithm = algorithm;
            this.keyData = keyData;
            this.initializationVector = initializationVector;
        }

        @Generated
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Generated
        public byte[] getKeyData() {
            return this.keyData;
        }

        @Generated
        public byte[] getInitializationVector() {
            return this.initializationVector;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnencryptedSymmetricDataEncryptionKey)) {
                return false;
            }
            UnencryptedSymmetricDataEncryptionKey other = (UnencryptedSymmetricDataEncryptionKey)o;
            String this$algorithm = this.getAlgorithm();
            String other$algorithm = other.getAlgorithm();
            if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
                return false;
            }
            if (!Arrays.equals(this.getKeyData(), other.getKeyData())) {
                return false;
            }
            return Arrays.equals(this.getInitializationVector(), other.getInitializationVector());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $algorithm = this.getAlgorithm();
            result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
            result = result * 59 + Arrays.hashCode(this.getKeyData());
            result = result * 59 + Arrays.hashCode(this.getInitializationVector());
            return result;
        }

        @Generated
        public static class UnencryptedSymmetricDataEncryptionKeyBuilder {
            @Generated
            private String algorithm;
            @Generated
            private byte[] keyData;
            @Generated
            private byte[] initializationVector;

            @Generated
            UnencryptedSymmetricDataEncryptionKeyBuilder() {
            }

            @Generated
            public UnencryptedSymmetricDataEncryptionKeyBuilder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            @Generated
            public UnencryptedSymmetricDataEncryptionKeyBuilder keyData(byte[] keyData) {
                this.keyData = keyData;
                return this;
            }

            @Generated
            public UnencryptedSymmetricDataEncryptionKeyBuilder initializationVector(byte[] initializationVector) {
                this.initializationVector = initializationVector;
                return this;
            }

            @Generated
            public UnencryptedSymmetricDataEncryptionKey build() {
                return new UnencryptedSymmetricDataEncryptionKey(this.algorithm, this.keyData, this.initializationVector);
            }

            @Generated
            public String toString() {
                return "StoredDataEncryptionKey.UnencryptedSymmetricDataEncryptionKey.UnencryptedSymmetricDataEncryptionKeyBuilder(algorithm=" + this.algorithm + ", keyData=" + Arrays.toString(this.keyData) + ", initializationVector=" + Arrays.toString(this.initializationVector) + ")";
            }
        }
    }
}

