/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.encryption.keys;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.springframework.content.encryption.engine.ContentEncryptionEngine;
import org.springframework.content.encryption.keys.DataEncryptionKeyWrapper;
import org.springframework.content.encryption.keys.StoredDataEncryptionKey;
import org.springframework.vault.core.VaultTransitOperations;
import org.springframework.vault.support.Ciphertext;
import org.springframework.vault.support.Plaintext;

public class VaultTransitDataEncryptionKeyWrapper
implements DataEncryptionKeyWrapper<StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey> {
    private static final String WRAPPING_ALGORITHM = "vault-transit";
    private final VaultTransitOperations transitOperations;
    private final String wrappingKeyId;

    @Override
    public boolean supports(StoredDataEncryptionKey storedDataEncryptionKey) {
        if (storedDataEncryptionKey instanceof StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey) {
            StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey dek = (StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey)storedDataEncryptionKey;
            return Objects.equals(dek.getWrappingAlgorithm(), WRAPPING_ALGORITHM) && Objects.equals(dek.getWrappingKeyId(), this.wrappingKeyId);
        }
        return false;
    }

    @Override
    public StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey wrapEncryptionKey(ContentEncryptionEngine.EncryptionParameters dataEncryptionParameters) {
        Plaintext plainText = Plaintext.of((byte[])dataEncryptionParameters.getSecretKey().getEncoded());
        Ciphertext encryptedKey = this.transitOperations.encrypt(this.wrappingKeyId, plainText);
        return new StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey(WRAPPING_ALGORITHM, this.wrappingKeyId, Integer.toString(encryptedKey.getContext().getKeyVersion()), dataEncryptionParameters.getSecretKey().getAlgorithm(), encryptedKey.getCiphertext().getBytes(StandardCharsets.UTF_8), dataEncryptionParameters.getInitializationVector());
    }

    @Override
    public ContentEncryptionEngine.EncryptionParameters unwrapEncryptionKey(StoredDataEncryptionKey.EncryptedSymmetricDataEncryptionKey encryptedDataEncryptionKey) {
        Ciphertext cipherText = Ciphertext.of((String)new String(encryptedDataEncryptionKey.getEncryptedKeyData(), StandardCharsets.UTF_8));
        Plaintext decryptedKey = this.transitOperations.decrypt(this.wrappingKeyId, cipherText);
        return new ContentEncryptionEngine.EncryptionParameters(new SecretKeySpec(decryptedKey.getPlaintext(), encryptedDataEncryptionKey.getDataEncryptionAlgorithm()), encryptedDataEncryptionKey.getInitializationVector());
    }

    @Generated
    public VaultTransitDataEncryptionKeyWrapper(VaultTransitOperations transitOperations, String wrappingKeyId) {
        this.transitOperations = transitOperations;
        this.wrappingKeyId = wrappingKeyId;
    }
}

