/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fs.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.utils.FileService;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;

public class FileSystemDeletableResource
implements WritableResource,
DeletableResource {
    private static Log logger = LogFactory.getLog(FileSystemDeletableResource.class);
    private final FileSystemResource resource;
    private final FileService fileService;

    public FileSystemDeletableResource(FileSystemResource resource, FileService fileService) {
        this.resource = resource;
        this.fileService = fileService;
    }

    public void delete() {
        File parent = null;
        try {
            parent = this.resource.getFile().getParentFile();
            FileUtils.forceDelete((File)this.getFile());
        }
        catch (IOException e) {
            logger.warn((Object)String.format("Unable to get file for resource %s", this.resource));
        }
        if (parent != null) {
            try {
                this.fileService.rmdirs(parent);
            }
            catch (IOException e) {
                logger.warn((Object)String.format("Removing orphaned directories starting at %s, left by removal of resource %s", parent.getAbsolutePath(), this.resource));
            }
        }
    }

    public boolean isOpen() {
        return this.resource.isOpen();
    }

    public final String getPath() {
        return this.resource.getPath();
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public boolean isReadable() {
        return this.resource.isReadable();
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public boolean isWritable() {
        return this.resource.isWritable();
    }

    public long lastModified() throws IOException {
        return this.resource.lastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.exists()) {
            FileUtils.touch((File)this.getFile());
        }
        return this.resource.getOutputStream();
    }

    public URL getURL() throws IOException {
        return this.resource.getURL();
    }

    public URI getURI() throws IOException {
        return this.resource.getURI();
    }

    public File getFile() {
        return this.resource.getFile();
    }

    public long contentLength() throws IOException {
        return this.resource.contentLength();
    }

    public Resource createRelative(String relativePath) {
        return this.resource.createRelative(relativePath);
    }

    public String toString() {
        return this.resource.toString();
    }

    public String getFilename() {
        return this.resource.getFilename();
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public boolean equals(Object obj) {
        return this.resource.equals(obj);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

