/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.fs.io;

import internal.org.springframework.content.fs.io.FileSystemDeletableResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.content.commons.utils.FileService;
import org.springframework.content.commons.utils.FileServiceImpl;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileSystemResourceLoader
extends org.springframework.core.io.FileSystemResourceLoader {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemResourceLoader.class);
    private FileSystemResource root;
    private FileService fileService = null;

    public FileSystemResourceLoader(String root) {
        Assert.notNull((Object)root);
        logger.info(String.format("Defaulting filesystem root to %s", root));
        this.root = new FileSystemResource(this.suffixPath(StringUtils.cleanPath((String)root)));
        this.fileService = new FileServiceImpl();
    }

    @Deprecated
    public String getFilesystemRoot() {
        return this.root.getPath();
    }

    public FileSystemResource getRootResource() {
        return this.root;
    }

    private String suffixPath(String path) {
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)this.root);
        Object resource = this.root.createRelative(location);
        if (resource instanceof FileSystemResource) {
            resource = new FileSystemDeletableResource((FileSystemResource)resource, this.fileService);
        }
        return resource;
    }
}

