/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.fs.config;

import java.net.URI;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.content.commons.utils.PlacementServiceImpl;
import org.springframework.content.fs.config.FilesystemStoreConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;

@Configuration
public class FilesystemStoreConfiguration {
    @Autowired(required=false)
    private List<FilesystemStoreConfigurer> configurers;

    @Bean
    public PlacementService filesystemStorePlacementService() {
        PlacementServiceImpl conversion = new PlacementServiceImpl();
        conversion.addConverter((Converter)new Converter<URI, String>(){

            public String convert(URI source) {
                return source.toString();
            }
        });
        this.addConverters((ConverterRegistry)conversion);
        return conversion;
    }

    protected void addConverters(ConverterRegistry registry) {
        if (this.configurers == null) {
            return;
        }
        for (FilesystemStoreConfigurer configurer : this.configurers) {
            configurer.configureFilesystemStoreConverters(registry);
        }
    }
}

