/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.renditions.renderers;

import internal.org.springframework.renditions.poi.POIServiceImpl;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.content.commons.renditions.RenditionProvider;
import org.springframework.content.renditions.RenditionException;
import org.springframework.renditions.poi.POIService;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class WordToJpegRenderer
implements RenditionProvider {
    private static Log logger = LogFactory.getLog(WordToJpegRenderer.class);
    private POIService poi = null;

    public WordToJpegRenderer() {
        this.poi = new POIServiceImpl();
    }

    public WordToJpegRenderer(POIService poi) {
        this.poi = poi;
    }

    public String consumes() {
        return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    }

    public String[] produces() {
        return new String[]{"image/jpg"};
    }

    public InputStream convert(InputStream fromInputSource, String toMimeType) {
        Assert.notNull((Object)fromInputSource, (String)"input source must not be null");
        XWPFDocument wordDoc = null;
        try {
            wordDoc = this.poi.xwpfDocument(fromInputSource);
        }
        catch (Exception e) {
            throw new RenditionException(String.format("Unexpected error reading input attempting to get mime-type rendition %s", toMimeType), e);
        }
        if (wordDoc != null) {
            try {
                POIXMLProperties props = wordDoc.getProperties();
                return props.getThumbnailImage();
            }
            catch (Exception e) {
                throw new RenditionException(String.format("Unexpected error getting thumbnail for mime-type rendition %s", toMimeType), e);
            }
        }
        return null;
    }
}

