/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.controllers.StoreHandlerMethodArgumentResolver;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.annotations.OriginalFileName;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.content.rest.controllers.ContentService;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;

public class ContentServiceHandlerMethodArgumentResolver
extends StoreHandlerMethodArgumentResolver {
    public ContentServiceHandlerMethodArgumentResolver(RestConfiguration config, Repositories repositories, RepositoryInvokerFactory repoInvokerFactory, ContentStoreService stores) {
        super(config, repositories, repoInvokerFactory, stores);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return ContentService.class.isAssignableFrom(parameter.getParameterType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String pathInfo = ((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getRequestURI();
        pathInfo = new UrlPathHelper().getPathWithinApplication((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        String[] pathSegments = (pathInfo = ContentStoreUtils.storeLookupPath(pathInfo, this.getConfig().getBaseUri())).split("/");
        if (pathSegments.length < 2) {
            return null;
        }
        String store = pathSegments[1];
        ContentStoreInfo info = ContentStoreUtils.findStore(this.getStores(), store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        if (AssociativeStore.class.isAssignableFrom(info.getInterface())) {
            if (pathSegments.length != 3) return this.resolveProperty(HttpMethod.valueOf((String)((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getMethod()), this.getRepositories(), this.getStores(), pathSegments, (i, e, p, propertyIsEmbedded) -> {
                if (ContentStore.class.isAssignableFrom(info.getInterface())) {
                    if (propertyIsEmbedded) {
                        return new ContentStoreContentService((ContentStore)info.getImplementation(ContentStore.class), this.getRepoInvokerFactory().getInvokerFor(e.getClass()), e, p);
                    }
                    return new ContentStoreContentService((ContentStore)info.getImplementation(ContentStore.class), this.getRepoInvokerFactory().getInvokerFor(p.getClass()), p);
                }
                throw new UnsupportedOperationException(String.format("ContentService for interface '%s' not implemented", info.getInterface()));
            });
            String id = pathSegments[2];
            Object domainObj = this.findOne(this.getRepoInvokerFactory(), this.getRepositories(), info.getDomainObjectClass(), id);
            if (ContentStore.class.isAssignableFrom(info.getInterface())) {
                return new ContentStoreContentService((ContentStore)info.getImplementation(ContentStore.class), this.getRepoInvokerFactory().getInvokerFor(domainObj.getClass()), domainObj);
            }
            if (!AssociativeStore.class.isAssignableFrom(info.getInterface())) throw new IllegalArgumentException();
            throw new UnsupportedOperationException("AssociativeStoreContentService not implemented");
        }
        if (!Store.class.isAssignableFrom(info.getInterface())) throw new IllegalArgumentException();
        return new StoreContentService((Store)info.getImplementation(Store.class));
    }

    public static class ContentStoreContentService
    implements ContentService {
        private final ContentStore store;
        private final RepositoryInvoker repoInvoker;
        private final Object domainObj;
        private final Object embeddedProperty;

        public ContentStoreContentService(ContentStore store, RepositoryInvoker repoInvoker, Object domainObj) {
            this.store = store;
            this.repoInvoker = repoInvoker;
            this.domainObj = domainObj;
            this.embeddedProperty = null;
        }

        public ContentStoreContentService(ContentStore store, RepositoryInvoker repoInvoker, Object domainObj, Object embeddedProperty) {
            this.store = store;
            this.repoInvoker = repoInvoker;
            this.domainObj = domainObj;
            this.embeddedProperty = embeddedProperty;
        }

        @Override
        public void setContent(InputStream content, MediaType mimeType, String originalFilename, Resource target) throws IOException {
            Object updatedDomainObj = this.store.setContent(this.embeddedProperty == null ? this.domainObj : this.embeddedProperty, content);
            if (BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), MimeType.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), MimeType.class, (Object)mimeType.toString());
            }
            if (originalFilename != null && StringUtils.hasText((String)originalFilename) && BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), OriginalFileName.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), OriginalFileName.class, (Object)originalFilename);
            }
            updatedDomainObj = this.repoInvoker.invokeSave(this.embeddedProperty == null ? updatedDomainObj : this.domainObj);
        }

        @Override
        public void unsetContent(Resource resource) {
            Object updatedDomainObj = this.store.unsetContent(this.embeddedProperty == null ? this.domainObj : this.embeddedProperty);
            if (BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), MimeType.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), MimeType.class, null);
            }
            if (BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), OriginalFileName.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), OriginalFileName.class, null);
            }
            this.repoInvoker.invokeSave(this.embeddedProperty == null ? updatedDomainObj : this.domainObj);
        }
    }

    public static class StoreContentService
    implements ContentService {
        private final Store store;

        public StoreContentService(Store store) {
            this.store = store;
        }

        @Override
        public void setContent(InputStream content, MediaType mimeType, String originalFilename, Resource target) throws IOException {
            InputStream in = content;
            OutputStream out = ((WritableResource)target).getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }

        @Override
        public void unsetContent(Resource resource) {
            Assert.notNull((Object)resource);
            if (resource instanceof DeletableResource) {
                try {
                    ((DeletableResource)resource).delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

