/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.controllers.StoreHandlerMethodArgumentResolver;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import javax.persistence.Version;
import javax.servlet.http.HttpServletRequest;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;

public class ResourceETagMethodArgumentResolver
extends StoreHandlerMethodArgumentResolver {
    public ResourceETagMethodArgumentResolver(RestConfiguration config, Repositories repositories, RepositoryInvokerFactory repoInvokerFactory, ContentStoreService stores) {
        super(config, repositories, repoInvokerFactory, stores);
    }

    @Override
    public boolean supportsParameter(MethodParameter methodParameter) {
        return "resourceETag".equals(methodParameter.getParameterName());
    }

    @Override
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        String pathInfo = ((HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class)).getRequestURI();
        pathInfo = new UrlPathHelper().getPathWithinApplication((HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class));
        String[] pathSegments = (pathInfo = ContentStoreUtils.storeLookupPath(pathInfo, this.getConfig().getBaseUri())).split("/");
        if (pathSegments.length < 2) {
            return null;
        }
        String store = pathSegments[1];
        ContentStoreInfo info = ContentStoreUtils.findStore(this.getStores(), store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        if (AssociativeStore.class.isAssignableFrom(info.getInterface())) {
            if (pathSegments.length == 3) {
                String id = pathSegments[2];
                Object domainObj = this.findOne(this.getRepoInvokerFactory(), this.getRepositories(), info.getDomainObjectClass(), id);
                Object version = BeanUtils.getFieldWithAnnotation((Object)domainObj, Version.class);
                if (version == null) {
                    version = "";
                }
                return version;
            }
            return this.resolveProperty(HttpMethod.valueOf((String)((HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class)).getMethod()), this.getRepositories(), this.getStores(), pathSegments, (s, e, p, propertyIsEmbedded) -> {
                Object version = BeanUtils.getFieldWithAnnotation((Object)p, Version.class);
                if (version == null) {
                    version = BeanUtils.getFieldWithAnnotation((Object)e, Version.class);
                }
                if (version == null) {
                    version = "";
                }
                return version.toString();
            });
        }
        return "";
    }
}

