/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.controllers.ResourceNotFoundException;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import internal.org.springframework.content.rest.utils.PersistentEntityUtils;
import internal.org.springframework.content.rest.utils.RepositoryUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.Embeddable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.util.UrlPathHelper;

public class StoreHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final RestConfiguration config;
    private final Repositories repositories;
    private final RepositoryInvokerFactory repoInvokerFactory;
    private final ContentStoreService stores;

    public StoreHandlerMethodArgumentResolver(RestConfiguration config, Repositories repositories, RepositoryInvokerFactory repoInvokerFactory, ContentStoreService stores) {
        this.config = config;
        this.repositories = repositories;
        this.repoInvokerFactory = repoInvokerFactory;
        this.stores = stores;
    }

    RestConfiguration getConfig() {
        return this.config;
    }

    protected Repositories getRepositories() {
        return this.repositories;
    }

    RepositoryInvokerFactory getRepoInvokerFactory() {
        return this.repoInvokerFactory;
    }

    protected ContentStoreService getStores() {
        return this.stores;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return Store.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String pathInfo = ((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getRequestURI();
        pathInfo = new UrlPathHelper().getPathWithinApplication((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        String[] pathSegments = pathInfo.split("/");
        if (pathSegments.length < 2) {
            return null;
        }
        String store = pathSegments[1];
        ContentStoreInfo info = ContentStoreUtils.findStore(this.stores, store);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        if (AssociativeStore.class.isAssignableFrom(info.getInterface())) {
            if (pathSegments.length > 3) {
                String id = pathSegments[2];
                Object domainObj = this.findOne(this.repoInvokerFactory, this.repositories, info.getDomainObjectClass(), id);
                Object contentId = BeanUtils.getFieldWithAnnotation((Object)domainObj, ContentId.class);
                if (contentId == null) {
                    throw new ResourceNotFoundException();
                }
                return info.getImplementation(AssociativeStore.class);
            }
        } else if (Store.class.isAssignableFrom(info.getInterface())) {
            return info.getImplementation(Store.class);
        }
        throw new IllegalArgumentException();
    }

    protected <T> Object resolveProperty(HttpMethod method, Repositories repositories, ContentStoreService stores, String[] segments, PropertyResolver<T> resolver) {
        ContentStoreInfo info;
        String repository = segments[1];
        String id = segments[2];
        String contentProperty = segments[3];
        String contentPropertyId = null;
        if (segments.length == 5) {
            contentPropertyId = segments[4];
        }
        Object domainObj = null;
        try {
            domainObj = this.findOne(this.repoInvokerFactory, repositories, repository, id);
        }
        catch (HttpRequestMethodNotSupportedException e) {
            throw new ResourceNotFoundException();
        }
        PersistentEntity entity = repositories.getPersistentEntity(domainObj.getClass());
        if (null == entity) {
            throw new ResourceNotFoundException();
        }
        PersistentProperty<?> property = this.getContentPropertyDefinition(entity, contentProperty);
        Class propertyClass = property.getActualType();
        if (this.isPrimitiveProperty(propertyClass)) {
            ContentStoreInfo info2 = ContentStoreUtils.findContentStore(stores, domainObj.getClass());
            if (info2 == null) {
                throw new IllegalStateException(String.format("Store for property %s not found", property.getName()));
            }
            return resolver.resolve(info2, domainObj, domainObj, false);
        }
        PersistentPropertyAccessor accessor = property.getOwner().getPropertyAccessor(domainObj);
        Object propVal = accessor.getProperty(property);
        if (propVal == null) {
            if (!PersistentEntityUtils.isPropertyMultiValued(property)) {
                propVal = this.instantiate(propertyClass);
                accessor.setProperty(property, propVal);
            }
        } else if (this.isCollectionElementRequest(contentPropertyId)) {
            if (!property.isArray() && property.isCollectionLike()) {
                // empty if block
            }
        } else {
            if (this.isCollectionRequest(contentPropertyId) && PersistentEntityUtils.isPropertyMultiValued(property) && (method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.DELETE))) {
                throw new MethodNotAllowedException("GET", null);
            }
            if (this.isCollectionRequest(contentPropertyId) && !property.isArray() && property.isCollectionLike()) {
                Object member = this.instantiate(propertyClass);
                Collection contentCollection = (Collection)accessor.getProperty(property);
                contentCollection.add(member);
                propVal = member;
            }
        }
        if ((info = ContentStoreUtils.findContentStore(stores, propertyClass)) == null) {
            throw new IllegalStateException(String.format("Store for property %s not found", property.getName()));
        }
        boolean embeddedProperty = false;
        if (PersistentEntityUtils.isPropertyMultiValued(property) || propVal.getClass().getAnnotation(Embeddable.class) != null) {
            embeddedProperty = true;
        }
        return resolver.resolve(info, domainObj, propVal, embeddedProperty);
    }

    private boolean isCollectionElementRequest(String contentPropertyId) {
        return contentPropertyId != null;
    }

    private boolean isCollectionRequest(String contentPropertyId) {
        return contentPropertyId == null;
    }

    private PersistentProperty<?> getContentPropertyDefinition(PersistentEntity<?, ?> persistentEntity, String contentProperty) {
        PersistentProperty prop = persistentEntity.getPersistentProperty(contentProperty);
        if (prop == null) {
            for (PersistentProperty candidate : persistentEntity.getPersistentProperties(ContentId.class)) {
                if (!candidate.getName().contains(contentProperty)) continue;
                prop = candidate;
            }
        }
        if (null == prop) {
            throw new ResourceNotFoundException();
        }
        return prop;
    }

    private boolean isPrimitiveProperty(Class<?> propClass) {
        return propClass.isPrimitive() || propClass.equals(UUID.class);
    }

    private Object findOne(RepositoryInvokerFactory repoInvokerFactory, Repositories repositories, String repository, String id) throws HttpRequestMethodNotSupportedException {
        RepositoryInformation ri = RepositoryUtils.findRepositoryInformation(repositories, repository);
        if (ri == null) {
            throw new ResourceNotFoundException();
        }
        Class domainObjClazz = ri.getDomainType();
        return this.findOne(repoInvokerFactory, repositories, domainObjClazz, id);
    }

    protected Object findOne(RepositoryInvokerFactory repoInvokerFactory, Repositories repositories, Class<?> domainObjClass, String id) throws HttpRequestMethodNotSupportedException {
        Optional domainObj = null;
        if (repoInvokerFactory != null) {
            RepositoryInvoker invoker = repoInvokerFactory.getInvokerFor(domainObjClass);
            if (invoker != null) {
                domainObj = invoker.invokeFindById((Object)id);
            }
        } else {
            RepositoryInformation ri = RepositoryUtils.findRepositoryInformation(repositories, domainObjClass);
            if (ri == null) {
                throw new ResourceNotFoundException();
            }
            Class domainObjClazz = ri.getDomainType();
            Class idClazz = ri.getIdType();
            Optional findOneMethod = ri.getCrudMethods().getFindOneMethod();
            if (!findOneMethod.isPresent()) {
                throw new HttpRequestMethodNotSupportedException("fineOne");
            }
            Object oid = new DefaultConversionService().convert((Object)id, idClazz);
            domainObj = (Optional)ReflectionUtils.invokeMethod((Method)((Method)findOneMethod.get()), repositories.getRepositoryFor(domainObjClazz).get(), (Object[])new Object[]{oid});
        }
        return domainObj.orElseThrow(ResourceNotFoundException::new);
    }

    private Object instantiate(Class<?> clazz) {
        Object newObject = null;
        try {
            newObject = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return newObject;
    }

    @FunctionalInterface
    public static interface PropertyResolver<S> {
        public S resolve(ContentStoreInfo var1, Object var2, Object var3, boolean var4);
    }
}

