/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.io;

import internal.org.springframework.content.rest.io.AssociatedResource;
import internal.org.springframework.content.rest.io.RenderableResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.time.ZonedDateTime;
import org.apache.commons.io.IOUtils;
import org.springframework.content.commons.renditions.Renderable;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.resource.HttpResource;

public class RenderableResourceImpl
implements Resource,
HttpResource,
RenderableResource {
    private final Renderable renderer;
    private final AssociatedResource original;
    private final long lastModified;

    public RenderableResourceImpl(Renderable renderer, AssociatedResource original) {
        this.renderer = renderer;
        this.original = original;
        this.lastModified = ZonedDateTime.now().toInstant().toEpochMilli();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRenderableAs(MimeType mimeType) {
        InputStream is = this.renderer.getRendition(this.original.getAssociation(), mimeType.toString());
        try {
            boolean bl = is != null;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @Override
    public InputStream renderAs(MimeType mimeType) {
        return this.renderer.getRendition(this.original.getAssociation(), mimeType.toString());
    }

    public InputStream getInputStream() throws IOException {
        return this.original.getInputStream();
    }

    public long contentLength() throws IOException {
        return this.original.contentLength();
    }

    public long lastModified() throws IOException {
        return this.original.lastModified();
    }

    public boolean exists() {
        return this.original.exists();
    }

    public boolean isReadable() {
        return this.original.isReadable();
    }

    public boolean isOpen() {
        return this.original.isOpen();
    }

    public boolean isFile() {
        return this.original.isFile();
    }

    public URL getURL() throws IOException {
        return this.original.getURL();
    }

    public URI getURI() throws IOException {
        return this.original.getURI();
    }

    public File getFile() throws IOException {
        return this.original.getFile();
    }

    public ReadableByteChannel readableChannel() throws IOException {
        return this.original.readableChannel();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.original.createRelative(relativePath);
    }

    @Nullable
    public String getFilename() {
        return this.original.getFilename();
    }

    public String getDescription() {
        return this.original.getDescription();
    }

    public HttpHeaders getResponseHeaders() {
        if (this.original instanceof HttpResource) {
            return ((HttpResource)this.original).getResponseHeaders();
        }
        return new HttpHeaders();
    }
}

