/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.time.ZonedDateTime;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;

public class RenderedResource
extends InputStreamResource {
    private Resource original;
    private long lastModified;

    public RenderedResource(InputStream rendition, Resource original) {
        super(rendition);
        this.original = original;
        this.lastModified = ZonedDateTime.now().toInstant().toEpochMilli();
    }

    public long contentLength() throws IOException {
        return -1L;
    }

    public long lastModified() throws IOException {
        return this.lastModified;
    }

    public boolean exists() {
        return this.original.exists();
    }

    public boolean isReadable() {
        return this.original.isReadable();
    }

    public boolean isOpen() {
        return this.original.isOpen();
    }

    public boolean isFile() {
        return this.original.isFile();
    }

    public URL getURL() throws IOException {
        return this.original.getURL();
    }

    public URI getURI() throws IOException {
        return this.original.getURI();
    }

    public File getFile() throws IOException {
        return this.original.getFile();
    }

    public ReadableByteChannel readableChannel() throws IOException {
        return this.original.readableChannel();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.original.createRelative(relativePath);
    }

    @Nullable
    public String getFilename() {
        return this.original.getFilename();
    }

    public String getDescription() {
        return this.original.getDescription();
    }
}

