/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.links;

import internal.org.springframework.content.rest.controllers.StoreRestController;
import internal.org.springframework.content.rest.utils.ContentStoreUtils;
import internal.org.springframework.content.rest.utils.DomainObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.content.commons.annotations.ContentId;
import org.springframework.content.commons.storeservice.ContentStoreInfo;
import org.springframework.content.commons.storeservice.ContentStoreService;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.StoreRestResource;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.io.Resource;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelProcessor;
import org.springframework.hateoas.server.core.LinkBuilderSupport;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class ContentLinksResourceProcessor
implements RepresentationModelProcessor<PersistentEntityResource> {
    private static final Log log = LogFactory.getLog(ContentLinksResourceProcessor.class);
    private static Method GET_CONTENT_METHOD = ReflectionUtils.findMethod(StoreRestController.class, (String)"getContent", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class, String.class, Resource.class, MediaType.class, Object.class});
    private ContentStoreService stores;
    private RestConfiguration config;

    public ContentLinksResourceProcessor(ContentStoreService stores, RestConfiguration config) {
        this.stores = stores;
        this.config = config;
    }

    RestConfiguration getRestConfiguration() {
        return this.config;
    }

    public PersistentEntityResource process(PersistentEntityResource resource) {
        Object object = resource.getContent();
        if (object == null) {
            return resource;
        }
        Object entityId = DomainObjectUtils.getId(object);
        ContentStoreInfo store = ContentStoreUtils.findContentStore(this.stores, object.getClass());
        Field[] fields = BeanUtils.findFieldsWithAnnotation(object.getClass(), ContentId.class, (BeanWrapper)new BeanWrapperImpl(object));
        if (fields.length == 1) {
            if (store != null) {
                if (this.config.fullyQualifiedLinks()) {
                    resource.add(this.fullyQualifiedLink(this.config.getBaseUri(), store, entityId, fields[0].getName()));
                } else {
                    this.originalLink(this.config.getBaseUri(), store, entityId).ifPresent(l -> this.addLink(resource, (Link)l));
                    this.addLink(resource, this.shortcutLink(this.config.getBaseUri(), store, entityId, StringUtils.uncapitalize((String)ContentStoreUtils.getSimpleName(store))));
                }
            }
        } else if (fields.length > 1) {
            for (Field field : fields) {
                resource.add(this.fullyQualifiedLink(this.config.getBaseUri(), store, entityId, field.getName()));
            }
        }
        return resource;
    }

    private void addLink(PersistentEntityResource resource, Link l) {
        if (resource.hasLink(l.getRel())) {
            for (Link existingLink : resource.getLinks(l.getRel())) {
                if (!existingLink.getHref().equals(l.getHref())) continue;
                return;
            }
        }
        resource.add(l);
    }

    private String propertyLinkRel(ContentStoreInfo storeInfo, String name) {
        String contentRel = StringUtils.uncapitalize((String)ContentStoreUtils.propertyName(name));
        Class storeIface = storeInfo.getInterface();
        StoreRestResource exportSpec = storeIface.getAnnotation(StoreRestResource.class);
        if (exportSpec != null && !StringUtils.isEmpty((Object)exportSpec.linkRel())) {
            contentRel = exportSpec.linkRel();
        }
        return contentRel;
    }

    private String entityRel(ContentStoreInfo storeInfo, String defaultLinkRel) {
        String entityLinkRel = defaultLinkRel;
        Class storeIface = storeInfo.getInterface();
        StoreRestResource exportSpec = storeIface.getAnnotation(StoreRestResource.class);
        if (exportSpec != null && !StringUtils.isEmpty((Object)exportSpec.linkRel())) {
            entityLinkRel = exportSpec.linkRel();
        }
        return entityLinkRel;
    }

    private Optional<Link> originalLink(URI baseUri, ContentStoreInfo store, Object id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.of(this.shortcutLink(baseUri, store, id, ContentStoreUtils.storePath(store)));
    }

    private Link shortcutLink(URI baseUri, ContentStoreInfo store, Object id, String defaultLinkRel) {
        StoreLinkBuilder builder = null;
        builder = StoreLinkBuilder.linkTo(new BaseUri(baseUri), store);
        builder = builder.slash(id);
        return builder.withRel(this.entityRel(store, defaultLinkRel));
    }

    private Link fullyQualifiedLink(URI baseUri, ContentStoreInfo store, Object id, String fieldName) {
        StoreLinkBuilder builder = StoreLinkBuilder.linkTo(new BaseUri(baseUri), store);
        builder = builder.slash(id);
        String property = StringUtils.uncapitalize((String)ContentStoreUtils.propertyName(fieldName));
        builder = builder.slash(property);
        return builder.withRel(this.propertyLinkRel(store, fieldName));
    }

    static {
        Assert.notNull((Object)GET_CONTENT_METHOD, (String)"Unable to find StoreRestController.getContent method");
    }

    public static class StoreLinkBuilder
    extends LinkBuilderSupport<StoreLinkBuilder> {
        public StoreLinkBuilder(BaseUri baseUri, ContentStoreInfo store) {
            super(baseUri.getUriComponentsBuilder().path(StoreLinkBuilder.storePath(store)).build());
        }

        protected StoreLinkBuilder getThis() {
            return this;
        }

        protected StoreLinkBuilder createNewInstance(UriComponentsBuilder builder, List list) {
            return new StoreLinkBuilder(new BaseUri(builder.toUriString()), null);
        }

        public static StoreLinkBuilder linkTo(BaseUri baseUri, ContentStoreInfo store) {
            return new StoreLinkBuilder(baseUri, store);
        }

        private static String storePath(ContentStoreInfo store) {
            if (store == null) {
                return "";
            }
            return String.format("/%s", ContentStoreUtils.storePath(store));
        }
    }
}

