/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.controllers.MethodNotAllowedException;
import internal.org.springframework.content.rest.controllers.StoreHandlerMethodArgumentResolver;
import internal.org.springframework.content.rest.io.RenderableResource;
import internal.org.springframework.content.rest.io.RenderedResource;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import internal.org.springframework.content.rest.utils.StoreUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.annotations.OriginalFileName;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.RestResource;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.content.rest.controllers.ContentService;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UrlPathHelper;

public class ContentServiceHandlerMethodArgumentResolver
extends StoreHandlerMethodArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(ContentServiceHandlerMethodArgumentResolver.class);
    private final StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;

    public ContentServiceHandlerMethodArgumentResolver(RestConfiguration config, Repositories repositories, RepositoryInvokerFactory repoInvokerFactory, Stores stores, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
        super(config, repositories, repoInvokerFactory, stores);
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return ContentService.class.isAssignableFrom(parameter.getParameterType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String pathInfo = ((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getRequestURI();
        pathInfo = new UrlPathHelper().getPathWithinApplication((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        String[] pathSegments = (pathInfo = StoreUtils.storeLookupPath(pathInfo, this.getConfig().getBaseUri())).split("/");
        if (pathSegments.length < 2) {
            return null;
        }
        String store = pathSegments[1];
        StoreInfo info = this.getStores().getStore(Store.class, StoreUtils.withStorePath(store));
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        if (AssociativeStore.class.isAssignableFrom(info.getInterface())) {
            if (pathSegments.length != 3) return this.resolveProperty(HttpMethod.valueOf((String)((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class)).getMethod()), this.getRepositories(), info, pathSegments, (i, e, p, propertyIsEmbedded) -> {
                if (ContentStore.class.isAssignableFrom(info.getInterface())) {
                    if (propertyIsEmbedded) {
                        return new ContentStoreContentService(this.getConfig(), info, this.getRepoInvokerFactory().getInvokerFor(e.getClass()), e, p, this.byteRangeRestRequestHandler);
                    }
                    return new ContentStoreContentService(this.getConfig(), info, this.getRepoInvokerFactory().getInvokerFor(p.getClass()), p, this.byteRangeRestRequestHandler);
                }
                throw new UnsupportedOperationException(String.format("ContentService for interface '%s' not implemented", info.getInterface()));
            });
            String id = pathSegments[2];
            Object domainObj = this.findOne(this.getRepoInvokerFactory(), this.getRepositories(), info.getDomainObjectClass(), id);
            if (ContentStore.class.isAssignableFrom(info.getInterface())) {
                return new ContentStoreContentService(this.getConfig(), info, this.getRepoInvokerFactory().getInvokerFor(domainObj.getClass()), domainObj, this.byteRangeRestRequestHandler);
            }
            if (!AssociativeStore.class.isAssignableFrom(info.getInterface())) throw new IllegalArgumentException();
            throw new UnsupportedOperationException("AssociativeStoreContentService not implemented");
        }
        if (!Store.class.isAssignableFrom(info.getInterface())) throw new IllegalArgumentException();
        return new StoreContentService((Store)info.getImplementation(Store.class), this.byteRangeRestRequestHandler);
    }

    private static boolean isClientAbortException(Exception e) {
        return e.getClass().getSimpleName().equals("ClientAbortException");
    }

    public static class ContentStoreContentService
    implements ContentService {
        private final RestConfiguration config;
        private final StoreInfo store;
        private final RepositoryInvoker repoInvoker;
        private final Object domainObj;
        private final Object embeddedProperty;
        private final StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;

        public ContentStoreContentService(RestConfiguration config, StoreInfo store, RepositoryInvoker repoInvoker, Object domainObj, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
            this.config = config;
            this.store = store;
            this.repoInvoker = repoInvoker;
            this.domainObj = domainObj;
            this.embeddedProperty = null;
            this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
        }

        public ContentStoreContentService(RestConfiguration config, StoreInfo store, RepositoryInvoker repoInvoker, Object domainObj, Object embeddedProperty, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
            this.config = config;
            this.store = store;
            this.repoInvoker = repoInvoker;
            this.domainObj = domainObj;
            this.embeddedProperty = embeddedProperty;
            this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
        }

        @Override
        public void getContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource resource, MediaType resourceType) throws ResponseStatusException, MethodNotAllowedException {
            block10: {
                Method[] methodsToUse = this.filterMethods(this.store.getInterface().getMethods(), this::withGetContentName, this::isOveridden, this::isExported);
                if (methodsToUse.length > 1) {
                    throw new IllegalStateException("Too many getContent methods");
                }
                if (methodsToUse.length == 0) {
                    throw new MethodNotAllowedException();
                }
                try {
                    MediaType producedResourceType = null;
                    List acceptedMimeTypes = headers.getAccept();
                    if (acceptedMimeTypes.size() > 0) {
                        MediaType.sortBySpecificityAndQuality((List)acceptedMimeTypes);
                        for (MediaType acceptedMimeType : acceptedMimeTypes) {
                            if (resource instanceof RenderableResource && ((RenderableResource)resource).isRenderableAs((org.springframework.util.MimeType)acceptedMimeType)) {
                                resource = new RenderedResource(((RenderableResource)resource).renderAs((org.springframework.util.MimeType)acceptedMimeType), (Resource)resource);
                                producedResourceType = acceptedMimeType;
                                break;
                            }
                            if (!acceptedMimeType.includes(resourceType)) continue;
                            producedResourceType = resourceType;
                            break;
                        }
                        if (producedResourceType == null) {
                            response.setStatus(HttpStatus.NOT_FOUND.value());
                            return;
                        }
                    }
                    request.setAttribute("SPRING_CONTENT_RESOURCE", resource);
                    request.setAttribute("SPRING_CONTENT_CONTENTTYPE", producedResourceType);
                }
                catch (Exception e) {
                    logger.error("Unable to retrieve content", (Throwable)e);
                    throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
                }
                try {
                    this.byteRangeRestRequestHandler.handleRequest(request, response);
                }
                catch (Exception e) {
                    if (ContentServiceHandlerMethodArgumentResolver.isClientAbortException(e)) break block10;
                    logger.error("Unable to handle request", (Throwable)e);
                    throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource source, MediaType sourceMimeType, Resource target) throws IOException, MethodNotAllowedException {
            Method[] methodsToUse;
            if (BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? this.domainObj : this.embeddedProperty), MimeType.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? this.domainObj : this.embeddedProperty), MimeType.class, (Object)sourceMimeType.toString());
            }
            String originalFilename = source.getFilename();
            if (source.getFilename() != null && StringUtils.hasText((String)originalFilename) && BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? this.domainObj : this.embeddedProperty), OriginalFileName.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? this.domainObj : this.embeddedProperty), OriginalFileName.class, (Object)originalFilename);
            }
            if ((methodsToUse = this.filterMethods(this.store.getInterface().getMethods(), this::withSetContentName, this::isOveridden, this::isExported)).length > 1) {
                RestConfiguration.DomainTypeConfig dtConfig = this.config.forDomainType(this.store.getDomainObjectClass());
                methodsToUse = this.filterMethods(methodsToUse, dtConfig.getSetContentResolver(), headers);
            }
            if (methodsToUse.length > 1) {
                throw new UnsupportedOperationException(String.format("Too many setContent methods exported.  Expected 1.  Got %s", methodsToUse.length));
            }
            if (methodsToUse.length == 0) {
                throw new MethodNotAllowedException();
            }
            Method methodToUse = methodsToUse[0];
            Object contentArg = this.convertContentArg(source, methodToUse.getParameterTypes()[1]);
            try {
                Object targetObj = this.store.getImplementation(ContentStore.class);
                ReflectionUtils.makeAccessible((Method)methodToUse);
                Object updatedDomainObj = ReflectionUtils.invokeMethod((Method)methodToUse, (Object)targetObj, (Object[])new Object[]{this.embeddedProperty == null ? this.domainObj : this.embeddedProperty, contentArg});
                this.repoInvoker.invokeSave(this.embeddedProperty == null ? updatedDomainObj : this.domainObj);
            }
            finally {
                this.cleanup(contentArg);
            }
        }

        @Override
        public void unsetContent(Resource resource) throws MethodNotAllowedException {
            Method[] methodsToUse = this.filterMethods(this.store.getInterface().getMethods(), this::withUnsetContentName, this::isOveridden, this::isExported);
            if (methodsToUse.length == 0) {
                throw new MethodNotAllowedException();
            }
            if (methodsToUse.length > 1) {
                throw new IllegalStateException("Too many unsetContent methods");
            }
            Object targetObj = this.store.getImplementation(ContentStore.class);
            ReflectionUtils.makeAccessible((Method)methodsToUse[0]);
            Object updatedDomainObj = ReflectionUtils.invokeMethod((Method)methodsToUse[0], (Object)targetObj, (Object[])new Object[]{this.embeddedProperty == null ? this.domainObj : this.embeddedProperty});
            if (BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), MimeType.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), MimeType.class, null);
            }
            if (BeanUtils.hasFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), OriginalFileName.class)) {
                BeanUtils.setFieldWithAnnotation((Object)(this.embeddedProperty == null ? updatedDomainObj : this.embeddedProperty), OriginalFileName.class, null);
            }
            this.repoInvoker.invokeSave(this.embeddedProperty == null ? updatedDomainObj : this.domainObj);
        }

        private boolean withGetContentName(Method method) {
            return method.getName().equals("getContent");
        }

        private boolean withSetContentName(Method method) {
            return method.getName().equals("setContent");
        }

        private boolean withUnsetContentName(Method method) {
            return method.getName().equals("unsetContent");
        }

        private boolean isOveridden(Method method) {
            return !method.isBridge();
        }

        private boolean isExported(Method method) {
            RestResource restResource = method.getAnnotation(RestResource.class);
            return restResource == null || restResource.exported();
        }

        private void cleanup(Object contentArg) {
            if (contentArg == null) {
                return;
            }
            if (FileSystemResource.class.isAssignableFrom(contentArg.getClass())) {
                ((FileSystemResource)contentArg).getFile().delete();
            }
        }

        private Object convertContentArg(Resource resource, Class<?> parameterType) {
            if (InputStream.class.equals(parameterType)) {
                try {
                    return resource.getInputStream();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Unable to get inputstream from resource %s", resource.getFilename()));
                }
            }
            if (Resource.class.equals(parameterType)) {
                try {
                    File f = Files.createTempFile("", "", new FileAttribute[0]).toFile();
                    FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)f);
                    return new FileSystemResource(f);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(String.format("Unable to re-purpose resource %s", resource.getFilename()));
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported content type %s", parameterType.getCanonicalName()));
        }

        private Method[] filterMethods(Method[] methods, Predicate<Method> ... filters) {
            return Stream.of(methods).filter(Arrays.stream(filters).reduce(Predicate::and).orElse(t -> true)).collect(Collectors.toList()).toArray(new Method[0]);
        }

        private Method[] filterMethods(Method[] methods, RestConfiguration.Resolver<Method, HttpHeaders> resolver, HttpHeaders headers) {
            ArrayList<Method> resolved = new ArrayList<Method>();
            for (Method method : methods) {
                if (!resolver.resolve(method, headers)) continue;
                resolved.add(method);
            }
            return resolved.toArray(new Method[0]);
        }
    }

    public static class StoreContentService
    implements ContentService {
        private final Store store;
        private final StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;

        public StoreContentService(Store store, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
            this.store = store;
            this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
        }

        @Override
        public void getContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource resource, MediaType resourceType) throws ResponseStatusException {
            block8: {
                try {
                    MediaType producedResourceType = null;
                    List acceptedMimeTypes = headers.getAccept();
                    if (acceptedMimeTypes.size() > 0) {
                        MediaType.sortBySpecificityAndQuality((List)acceptedMimeTypes);
                        for (MediaType acceptedMimeType : acceptedMimeTypes) {
                            if (resource instanceof RenderableResource && ((RenderableResource)resource).isRenderableAs((org.springframework.util.MimeType)acceptedMimeType)) {
                                resource = new RenderedResource(((RenderableResource)resource).renderAs((org.springframework.util.MimeType)acceptedMimeType), (Resource)resource);
                                producedResourceType = acceptedMimeType;
                                break;
                            }
                            if (!acceptedMimeType.includes(resourceType)) continue;
                            producedResourceType = resourceType;
                            break;
                        }
                        if (producedResourceType == null) {
                            response.setStatus(HttpStatus.NOT_FOUND.value());
                            return;
                        }
                    }
                    request.setAttribute("SPRING_CONTENT_RESOURCE", resource);
                    request.setAttribute("SPRING_CONTENT_CONTENTTYPE", producedResourceType);
                }
                catch (Exception e) {
                    logger.error("Unable to retrieve content", (Throwable)e);
                    throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
                }
                try {
                    this.byteRangeRestRequestHandler.handleRequest(request, response);
                }
                catch (Exception e) {
                    if (ContentServiceHandlerMethodArgumentResolver.isClientAbortException(e)) break block8;
                    logger.error("Unable to handle request", (Throwable)e);
                    throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
                }
            }
        }

        @Override
        public void setContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource source, MediaType sourceMimeType, Resource target) throws IOException, MethodNotAllowedException {
            InputStream in = source.getInputStream();
            OutputStream out = ((WritableResource)target).getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }

        @Override
        public void unsetContent(Resource resource) {
            Assert.notNull((Object)resource);
            if (resource instanceof DeletableResource) {
                try {
                    ((DeletableResource)resource).delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

