/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import internal.org.springframework.content.rest.controllers.StoreHandlerMethodArgumentResolver;
import internal.org.springframework.content.rest.utils.StoreUtils;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.content.commons.annotations.MimeType;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.commons.utils.BeanUtils;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;

public class ResourceTypeMethodArgumentResolver
extends StoreHandlerMethodArgumentResolver {
    public ResourceTypeMethodArgumentResolver(RestConfiguration config, Repositories repositories, RepositoryInvokerFactory repoInvokerFactory, Stores stores) {
        super(config, repositories, repoInvokerFactory, stores);
    }

    @Override
    public boolean supportsParameter(MethodParameter methodParameter) {
        return "resourceType".equals(methodParameter.getParameterName());
    }

    @Override
    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        String pathInfo = ((HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class)).getRequestURI();
        pathInfo = new UrlPathHelper().getPathWithinApplication((HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class));
        String[] pathSegments = (pathInfo = StoreUtils.storeLookupPath(pathInfo, this.getConfig().getBaseUri())).split("/");
        if (pathSegments.length < 2) {
            return null;
        }
        String store = pathSegments[1];
        StoreInfo info = this.getStores().getStore(Store.class, StoreUtils.withStorePath(store));
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        if (AssociativeStore.class.isAssignableFrom(info.getInterface())) {
            if (pathSegments.length == 3) {
                String id = pathSegments[2];
                Object domainObj = this.findOne(this.getRepoInvokerFactory(), this.getRepositories(), info.getDomainObjectClass(), id);
                Object mimeType = BeanUtils.getFieldWithAnnotation((Object)domainObj, MimeType.class);
                return MediaType.valueOf((String)(mimeType != null ? mimeType.toString() : "*/*"));
            }
            return this.resolveProperty(HttpMethod.valueOf((String)((HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class)).getMethod()), this.getRepositories(), info, pathSegments, (s, e, p, propertyIsEmbedded) -> {
                Object mimeType = BeanUtils.getFieldWithAnnotation((Object)p, MimeType.class);
                return MediaType.valueOf((String)(mimeType != null ? mimeType.toString() : "*/*"));
            });
        }
        if (Store.class.isAssignableFrom(info.getInterface())) {
            String path = new UrlPathHelper().getPathWithinApplication((HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class));
            String pathToUse = path.substring(StoreUtils.storePath(info).length() + 1);
            String mimeType = new MimetypesFileTypeMap().getContentType(pathToUse);
            return MediaType.valueOf((String)(mimeType != null ? mimeType : ""));
        }
        return null;
    }
}

