/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers;

import com.fasterxml.jackson.annotation.JsonProperty;
import internal.org.springframework.content.rest.controllers.MethodNotAllowedException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PessimisticLockException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.versions.LockOwnerException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackageClasses={StoreRestExceptionHandler.class})
public class StoreRestExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(StoreRestExceptionHandler.class);

    @ExceptionHandler(value={LockOwnerException.class, OptimisticLockException.class, OptimisticLockingFailureException.class, PessimisticLockException.class, PessimisticLockingFailureException.class})
    ResponseEntity<ExceptionMessage> handleConflict(Exception e) {
        return StoreRestExceptionHandler.errorResponse(HttpStatus.CONFLICT, new HttpHeaders(), e);
    }

    @ExceptionHandler(value={MethodNotAllowedException.class})
    public ResponseEntity<Object> handle(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        return ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).build();
    }

    private static ResponseEntity<ExceptionMessage> errorResponse(HttpStatus status, HttpHeaders headers, Exception exception) {
        if (exception != null) {
            String message = exception.getMessage();
            logger.error(message, (Throwable)exception);
            if (StringUtils.hasText((String)message)) {
                return StoreRestExceptionHandler.response(status, headers, new ExceptionMessage(exception));
            }
        }
        return StoreRestExceptionHandler.response(status, headers, null);
    }

    private static <T> ResponseEntity<T> response(HttpStatus status, HttpHeaders headers, T body) {
        Assert.notNull((Object)headers, (String)"Headers must not be null!");
        Assert.notNull((Object)status, (String)"HttpStatus must not be null!");
        return new ResponseEntity(body, (MultiValueMap)headers, status);
    }

    public static class ExceptionMessage {
        private final Throwable throwable;

        public ExceptionMessage(Throwable throwable) {
            this.throwable = throwable;
        }

        @JsonProperty(value="message")
        public String getMessage() {
            return this.throwable.getMessage();
        }

        @JsonProperty(value="cause")
        public ExceptionMessage getCause() {
            return this.throwable.getCause() != null ? new ExceptionMessage(this.throwable.getCause()) : null;
        }
    }
}

