/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappings;

import internal.org.springframework.content.rest.annotations.ContentRestController;
import internal.org.springframework.content.rest.mappings.CorsConfigurationBuilder;
import internal.org.springframework.content.rest.mappings.StoreAwareHandlerMapping;
import internal.org.springframework.content.rest.utils.StoreUtils;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.util.UrlPathHelper;

public class ContentHandlerMapping
extends StoreAwareHandlerMapping {
    private static MediaType hal = MediaType.parseMediaType((String)"application/hal+json");
    private static MediaType json = MediaType.parseMediaType((String)"application/json");
    private Stores contentStores;

    public ContentHandlerMapping(Stores contentStores, RestConfiguration config) {
        super(config);
        this.contentStores = contentStores;
        this.setOrder(0x7FFFFF37);
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, ContentRestController.class) != null;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        String storeLookupPath = StoreUtils.storeLookupPath(lookupPath, this.getConfiguration().getBaseUri());
        if (storeLookupPath != null) {
            String[] path = storeLookupPath.split("/");
            if (path.length < 3) {
                return null;
            }
            StoreInfo info2 = this.contentStores.getStore(Store.class, StoreUtils.withStorePath(path[1]));
            if (info2 != null && !this.isHalOrJsonRequest(request)) {
                return super.lookupHandlerMethod(lookupPath, request);
            }
        }
        return null;
    }

    protected boolean hasCorsConfigurationSource(Object handler) {
        return true;
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        String storeLookupPath = StoreUtils.storeLookupPath(lookupPath, this.getConfiguration().getBaseUri());
        CorsConfiguration corsConfiguration = super.getCorsConfiguration(handler, request);
        if (storeLookupPath == null) {
            return corsConfiguration;
        }
        String[] path = storeLookupPath.split("/");
        if (path.length < 3) {
            return corsConfiguration;
        }
        StoreInfo info2 = this.contentStores.getStore(Store.class, StoreUtils.withStorePath(path[1]));
        if (info2 == null) {
            return corsConfiguration;
        }
        CorsConfigurationBuilder builder = new CorsConfigurationBuilder();
        CorsConfiguration storeCorsConfiguration = builder.build(info2.getInterface());
        return corsConfiguration == null ? storeCorsConfiguration : corsConfiguration.combine(storeCorsConfiguration);
    }

    private boolean isHalOrJsonRequest(HttpServletRequest request) {
        String method = request.getMethod();
        if ("GET".equals(method) || "DELETE".equals(method)) {
            String accept = request.getHeader("Accept");
            if (accept != null) {
                try {
                    List mediaTypes = MediaType.parseMediaTypes((String)accept);
                    for (MediaType mediaType : mediaTypes) {
                        if (!mediaType.equals((Object)hal) && !mediaType.equals((Object)json)) continue;
                        return true;
                    }
                }
                catch (InvalidMediaTypeException imte) {
                    return true;
                }
            }
        } else if ("PUT".equals(method) || "POST".equals(method)) {
            String contentType = request.getHeader("Content-Type");
            if (contentType != null) {
                try {
                    List mediaTypes = MediaType.parseMediaTypes((String)contentType);
                    for (MediaType mediaType : mediaTypes) {
                        if (!mediaType.equals((Object)hal) && !mediaType.equals((Object)json)) continue;
                        return true;
                    }
                }
                catch (InvalidMediaTypeException imte) {
                    return true;
                }
            }
        } else if ("PATCH".equals(method) || "HEAD".equals(method)) {
            return true;
        }
        return false;
    }

    protected void detectHandlerMethods(Object handler) {
        super.detectHandlerMethods(handler);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        StoreType typeAnnotation = (StoreType)AnnotationUtils.findAnnotation((Method)method, StoreType.class);
        if (typeAnnotation != null) {
            return new StoreCondition(typeAnnotation, this.contentStores, method, this.getConfiguration().getBaseUri());
        }
        return null;
    }

    public static class StoreCondition
    implements RequestCondition<StoreCondition> {
        private String storeType = "store";
        private Stores stores;
        private Method method;
        private URI baseUri;

        public StoreCondition(StoreType typeAnnotation, Stores stores, Method method, URI baseUri) {
            this.storeType = typeAnnotation.value();
            this.stores = stores;
            this.method = method;
            this.baseUri = baseUri;
        }

        public StoreCondition combine(StoreCondition other) {
            throw new UnsupportedOperationException();
        }

        public StoreCondition getMatchingCondition(HttpServletRequest request) {
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String storeLookupPath = StoreUtils.storeLookupPath(path, this.baseUri);
            String[] segments = storeLookupPath.split("/");
            if (segments.length < 3) {
                return null;
            }
            StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(segments[1]));
            if (info != null && (Store.class.isAssignableFrom(info.getInterface()) && "store".equals(this.storeType) || ContentStore.class.isAssignableFrom(info.getInterface()) && "contentstore".equals(this.storeType))) {
                return this;
            }
            return null;
        }

        public int compareTo(StoreCondition other, HttpServletRequest request) {
            if (this.isMappingForRequest(request) && !other.isMappingForRequest(request)) {
                return 1;
            }
            if (!this.isMappingForRequest(request) && other.isMappingForRequest(request)) {
                return -1;
            }
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String storeLookupPath = StoreUtils.storeLookupPath(path, this.baseUri);
            String filename = FilenameUtils.getName((String)storeLookupPath);
            String extension = FilenameUtils.getExtension((String)filename);
            if (extension != null && "store".equals(this.storeType)) {
                return -1;
            }
            if (extension != null && "contentstore".equals(this.storeType)) {
                return 1;
            }
            return 0;
        }

        public boolean isMappingForRequest(HttpServletRequest request) {
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String storeLookupPath = StoreUtils.storeLookupPath(path, this.baseUri);
            String[] segments = storeLookupPath.split("/");
            if (segments.length < 3) {
                return false;
            }
            StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(segments[1]));
            return info != null && Store.class.isAssignableFrom(info.getInterface()) && "store".equals(this.storeType) || ContentStore.class.isAssignableFrom(info.getInterface()) && "contentstore".equals(this.storeType);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface StoreType {
        public String value() default "store";
    }
}

