/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;

public class HeaderUtils {
    private static final Pattern ETAG_HEADER_VALUE_PATTERN = Pattern.compile("\\*|\\s*((W\\/)?(\"[^\"]*\"))\\s*,?");
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    private static final ConfigurableConversionService conversionService = new DefaultConversionService();

    public HeaderUtils() {
        Jsr310Converters.getConvertersToRegister().forEach(arg_0 -> ((ConfigurableConversionService)conversionService).addConverter(arg_0));
    }

    public static void evaluateHeaderConditions(HttpHeaders headers, String resourceETag, Object resourceLastModified) {
        boolean noneMatch;
        Long lastModified;
        boolean unmodified;
        if (HeaderUtils.ifMatchPresent(headers)) {
            boolean matches = HeaderUtils.checkIfMatchCondition(headers, resourceETag);
            if (!matches) {
                throw new ResponseStatusException(HttpStatus.PRECONDITION_FAILED, String.format("Entity If-Match %s failed", headers.getIfMatch().get(0)));
            }
        } else if (HeaderUtils.isIfUnmodifiedSincePresent(headers) && resourceLastModified != null && !(unmodified = HeaderUtils.checkIfUnmodifiedSinceCondition(headers, lastModified = Stream.of(resourceLastModified).filter(it -> it != null).map(it -> (Date)conversionService.convert(it, Date.class)).map(it -> (Instant)conversionService.convert(it, Instant.class)).map(it -> it.toEpochMilli()).findFirst().orElse(-1L)))) {
            throw new ResponseStatusException(HttpStatus.PRECONDITION_FAILED, String.format("Entity modified since %s", headers.get((Object)"If-Unmodified-Since").get(0)));
        }
        if (!(noneMatch = HeaderUtils.checkIfNoneMatchCondition(headers, resourceETag))) {
            throw new ResponseStatusException(HttpStatus.PRECONDITION_FAILED, String.format("Entity If-None-Match %s failed", StringUtils.collectionToCommaDelimitedString((Collection)headers.get((Object)"If-None-Match"))));
        }
    }

    public static boolean ifMatchPresent(HttpHeaders headers) {
        return headers.getIfMatch().size() > 0;
    }

    public static boolean checkIfMatchCondition(HttpHeaders headers, String resourceETag) {
        boolean matches;
        if (resourceETag == null) {
            return true;
        }
        Iterator ifMatch = headers.getIfMatch().iterator();
        boolean bl = matches = !ifMatch.hasNext();
        if (StringUtils.hasText((String)resourceETag)) {
            resourceETag = HeaderUtils.padEtagIfNecessary(resourceETag);
            while (ifMatch.hasNext()) {
                String clientETags = (String)ifMatch.next();
                Matcher etagMatcher = ETAG_HEADER_VALUE_PATTERN.matcher(clientETags);
                while (etagMatcher.find()) {
                    if (!StringUtils.hasLength((String)etagMatcher.group()) || !resourceETag.replaceFirst("^W/", "").equals(etagMatcher.group(3))) continue;
                    matches = true;
                }
            }
        }
        return matches;
    }

    public static boolean checkIfNoneMatchCondition(HttpHeaders headers, String resourceETag) {
        boolean matches = false;
        Iterator ifNoneMatch = headers.getIfNoneMatch().iterator();
        if (StringUtils.hasText((String)resourceETag)) {
            resourceETag = HeaderUtils.padEtagIfNecessary(resourceETag);
            while (ifNoneMatch.hasNext()) {
                String clientETags = (String)ifNoneMatch.next();
                Matcher etagMatcher = ETAG_HEADER_VALUE_PATTERN.matcher(clientETags);
                while (etagMatcher.find()) {
                    if (!StringUtils.hasLength((String)etagMatcher.group()) || !resourceETag.replaceFirst("^W/", "").equals(etagMatcher.group(3))) continue;
                    matches = true;
                }
            }
        }
        return !matches;
    }

    public static boolean isIfUnmodifiedSincePresent(HttpHeaders headers) {
        return headers.getIfUnmodifiedSince() != -1L;
    }

    public static boolean checkIfUnmodifiedSinceCondition(HttpHeaders headers, long lastModifiedTimestamp) {
        if (lastModifiedTimestamp < 0L) {
            return false;
        }
        long ifUnmodifiedSince = HeaderUtils.parseDateHeader(headers, "If-Unmodified-Since");
        if (ifUnmodifiedSince == -1L) {
            return false;
        }
        return ifUnmodifiedSince >= lastModifiedTimestamp / 1000L * 1000L;
    }

    public static String padEtagIfNecessary(String etag) {
        if (!StringUtils.hasLength((String)etag)) {
            return etag;
        }
        if ((etag.startsWith("\"") || etag.startsWith("W/\"")) && etag.endsWith("\"")) {
            return etag;
        }
        return "\"" + etag + "\"";
    }

    public static long parseDateHeader(HttpHeaders headers, String headerName) {
        long dateValue;
        block2: {
            dateValue = -1L;
            try {
                dateValue = headers.getIfUnmodifiedSince();
            }
            catch (IllegalArgumentException ex) {
                int separatorIndex;
                String headerValue = headers.getFirst(headerName);
                if (headerValue == null || (separatorIndex = headerValue.indexOf(59)) == -1) break block2;
                String datePart = headerValue.substring(0, separatorIndex);
                dateValue = HeaderUtils.parseDateValue(datePart);
            }
        }
        return dateValue;
    }

    public static long parseDateValue(@Nullable String headerValue) {
        if (headerValue == null) {
            return -1L;
        }
        if (headerValue.length() >= 3) {
            for (String dateFormat : DATE_FORMATS) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    return simpleDateFormat.parse(headerValue).getTime();
                }
                catch (ParseException parseException) {
                }
            }
        }
        return -1L;
    }
}

