/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.contentservice;

import internal.org.springframework.content.rest.contentservice.ContentService;
import internal.org.springframework.content.rest.controllers.BadRequestException;
import internal.org.springframework.content.rest.controllers.MethodNotAllowedException;
import internal.org.springframework.content.rest.io.AssociatedStoreResource;
import internal.org.springframework.content.rest.io.RenderedResource;
import internal.org.springframework.content.rest.io.StoreResource;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToExportedContext;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.SetContentParams;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.repository.UnsetContentParams;
import org.springframework.content.commons.store.SetContentParams;
import org.springframework.content.commons.store.UnsetContentParams;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.utils.StoreInterfaceUtils;
import org.springframework.content.rest.RestResource;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.async.AsyncRequestNotUsableException;
import org.springframework.web.server.ResponseStatusException;

public class ContentStoreContentService
implements ContentService {
    private static final Logger logger = LoggerFactory.getLogger(ContentStoreContentService.class);
    private static final Map<String, StoreExportedMethodsMap> storeExportedMethods = new HashMap<String, StoreExportedMethodsMap>();
    private final RestConfiguration config;
    private final RepositoryInvoker repoInvoker;
    private final MappingContext mappingContext;
    private final ContentPropertyToExportedContext exportContext;
    private final StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;

    public ContentStoreContentService(RestConfiguration config, StoreInfo store, RepositoryInvoker repoInvoker, MappingContext mappingContext, ContentPropertyToExportedContext exportContext, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
        this.config = config;
        this.repoInvoker = repoInvoker;
        this.mappingContext = mappingContext;
        this.exportContext = exportContext;
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
    }

    @Override
    public void getContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource resource, MediaType resourceType) throws ResponseStatusException, MethodNotAllowedException {
        block12: {
            AssociatedStoreResource storeResource = (AssociatedStoreResource)resource;
            ContentProperty property = storeResource.getContentProperty();
            Method[] methodsToUse = ContentStoreContentService.getExportedMethodsFor(storeResource.getStoreInfo().getInterface(), storeResource.getPropertyPath(), this.exportContext).getContentMethods();
            if (methodsToUse.length > 1) {
                throw new IllegalStateException("Too many getContent methods");
            }
            if (methodsToUse.length == 0) {
                throw new MethodNotAllowedException();
            }
            try {
                MediaType producedResourceType = null;
                Resource storedRenditionResource = null;
                List acceptedMimeTypes = headers.getAccept();
                if (acceptedMimeTypes.size() > 0) {
                    MediaType.sortBySpecificityAndQuality((List)acceptedMimeTypes);
                    for (MediaType acceptedMimeType : acceptedMimeTypes) {
                        if (acceptedMimeType.includes(resourceType) && this.matchParameters(acceptedMimeType, resourceType)) {
                            producedResourceType = resourceType;
                            break;
                        }
                        storedRenditionResource = this.findStoredRendition(storeResource, acceptedMimeType);
                        if (storedRenditionResource != null) {
                            resource = storedRenditionResource;
                            producedResourceType = acceptedMimeType;
                            break;
                        }
                        if (!((StoreResource)resource).isRenderableAs((MimeType)acceptedMimeType)) continue;
                        resource = new RenderedResource(((StoreResource)resource).renderAs((MimeType)acceptedMimeType), (Resource)resource);
                        producedResourceType = acceptedMimeType;
                        break;
                    }
                    if (producedResourceType == null) {
                        response.setStatus(HttpStatus.NOT_FOUND.value());
                        return;
                    }
                }
                if (resource instanceof RangeableResource) {
                    this.configureResourceForByteRangeRequest((RangeableResource)resource, headers);
                }
                request.setAttribute("SPRING_CONTENT_RESOURCE", resource);
                request.setAttribute("SPRING_CONTENT_CONTENTTYPE", producedResourceType);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve content", (Throwable)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
            }
            try {
                this.byteRangeRestRequestHandler.handleRequest(request, response);
            }
            catch (Exception e) {
                if (ContentStoreContentService.isClientAbortException(e)) break block12;
                logger.error("Unable to handle request", (Throwable)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource source, MediaType sourceMimeType, Resource target) throws IOException, MethodNotAllowedException {
        Method[] methodsToUse;
        if (sourceMimeType == null) {
            throw new BadRequestException("Missing Content-Type header");
        }
        AssociatedStoreResource storeResource = (AssociatedStoreResource)target;
        ContentProperty property = storeResource.getContentProperty();
        Object domainObject = storeResource.getAssociation();
        property.setMimeType(domainObject, (Object)sourceMimeType.toString());
        String originalFilename = source.getFilename();
        if (source.getFilename() != null && StringUtils.hasText((String)originalFilename)) {
            property.setOriginalFileName(domainObject, (Object)source.getFilename());
        }
        if ((methodsToUse = ContentStoreContentService.getExportedMethodsFor(storeResource.getStoreInfo().getInterface(), storeResource.getPropertyPath(), this.exportContext).setContentMethods()).length > 1) {
            RestConfiguration.DomainTypeConfig dtConfig = this.config.forDomainType(storeResource.getStoreInfo().getDomainObjectClass());
            methodsToUse = this.filterMethods(methodsToUse, dtConfig.getSetContentResolver(), headers);
        }
        if (methodsToUse.length > 1) {
            throw new UnsupportedOperationException(String.format("Too many setContent methods exported.  Expected 1.  Got %s", methodsToUse.length));
        }
        if (methodsToUse.length == 0) {
            throw new MethodNotAllowedException();
        }
        Method methodToUse = methodsToUse[0];
        ArrayList<Object> argsList = new ArrayList<Object>();
        argsList.add(domainObject);
        argsList.add(storeResource.getPropertyPath());
        Object contentArg = this.convertContentArg(source, methodToUse.getParameterTypes()[this.indexOfContentArg(methodToUse.getParameterTypes())]);
        argsList.add(contentArg);
        if (methodToUse.getParameters().length > 3 && methodToUse.getParameters()[3].getType().equals(Long.TYPE)) {
            long len = -1L;
            if (headers.containsKey((Object)"Content-Length")) {
                len = headers.getContentLength();
            }
            argsList.add(len);
        } else if (methodToUse.getParameters().length > 3 && methodToUse.getParameters()[3].getType().equals(SetContentParams.class)) {
            SetContentParams params = SetContentParams.builder().build();
            if (headers.containsKey((Object)"Content-Length")) {
                params.setContentLength(headers.getContentLength());
            }
            ordinal = this.config.getSetContentDisposition().ordinal();
            params.setDisposition(SetContentParams.ContentDisposition.values()[ordinal]);
            argsList.add(params);
        } else if (methodToUse.getParameters().length > 3 && methodToUse.getParameters()[3].getType().equals(org.springframework.content.commons.repository.SetContentParams.class)) {
            org.springframework.content.commons.repository.SetContentParams params = org.springframework.content.commons.repository.SetContentParams.builder().build();
            if (headers.containsKey((Object)"Content-Length")) {
                params.setContentLength(headers.getContentLength());
            }
            ordinal = this.config.getSetContentDisposition().ordinal();
            params.setDisposition(SetContentParams.ContentDisposition.values()[ordinal]);
            argsList.add(params);
        }
        try {
            Object targetObj = storeResource.getStoreInfo().getImplementation(ContentStore.class);
            ReflectionUtils.makeAccessible((Method)methodToUse);
            Object updatedDomainObj = ReflectionUtils.invokeMethod((Method)methodToUse, (Object)targetObj, (Object[])argsList.toArray());
            this.repoInvoker.invokeSave(updatedDomainObj);
        }
        finally {
            this.cleanup(contentArg);
        }
    }

    @Override
    public void unsetContent(Resource resource) throws MethodNotAllowedException {
        AssociatedStoreResource storeResource = (AssociatedStoreResource)resource;
        ContentProperty property = storeResource.getContentProperty();
        Method[] methodsToUse = ContentStoreContentService.getExportedMethodsFor(storeResource.getStoreInfo().getInterface(), storeResource.getPropertyPath(), this.exportContext).unsetContentMethods();
        if (methodsToUse.length == 0) {
            throw new MethodNotAllowedException();
        }
        if (methodsToUse.length > 1) {
            throw new IllegalStateException("Too many unsetContent methods");
        }
        Object updateObject = storeResource.getAssociation();
        Object targetObj = storeResource.getStoreInfo().getImplementation(ContentStore.class);
        org.springframework.content.commons.store.UnsetContentParams unsetParams = null;
        if (methodsToUse[0].getParameters().length == 3 && methodsToUse[0].getParameters()[2].getType().equals(org.springframework.content.commons.store.UnsetContentParams.class)) {
            params = org.springframework.content.commons.store.UnsetContentParams.builder().build();
            int ordinal = this.config.getUnsetContentDisposition().ordinal();
            params.setDisposition(UnsetContentParams.Disposition.values()[ordinal]);
            unsetParams = params;
        } else if (methodsToUse[0].getParameters().length == 3 && methodsToUse[0].getParameters()[2].getType().equals(UnsetContentParams.class)) {
            params = UnsetContentParams.builder().build();
            int ordinal = this.config.getUnsetContentDisposition().ordinal();
            params.setDisposition(UnsetContentParams.Disposition.values()[ordinal]);
            unsetParams = params;
        }
        ReflectionUtils.makeAccessible((Method)methodsToUse[0]);
        Object updatedDomainObj = ReflectionUtils.invokeMethod((Method)methodsToUse[0], (Object)targetObj, (Object[])new Object[]{updateObject, storeResource.getPropertyPath(), unsetParams});
        updateObject = updatedDomainObj;
        property.setMimeType(updateObject, null);
        property.setOriginalFileName(updateObject, null);
        this.repoInvoker.invokeSave(updateObject);
    }

    private void cleanup(Object contentArg) {
        if (contentArg == null) {
            return;
        }
        if (FileSystemResource.class.isAssignableFrom(contentArg.getClass())) {
            ((FileSystemResource)contentArg).getFile().delete();
        }
    }

    private Object convertContentArg(Resource resource, Class<?> parameterType) {
        if (InputStream.class.equals(parameterType)) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Unable to get inputstream from resource %s", resource.getFilename()));
            }
        }
        if (Resource.class.equals(parameterType)) {
            try {
                File f = Files.createTempFile("", "", new FileAttribute[0]).toFile();
                FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)f);
                return new FileSystemResource(f);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Unable to re-purpose resource %s", resource.getFilename()));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported content type %s", parameterType.getCanonicalName()));
    }

    private Method[] filterMethods(Method[] methods, RestConfiguration.Resolver<Method, HttpHeaders> resolver, HttpHeaders headers) {
        ArrayList<Method> resolved = new ArrayList<Method>();
        for (Method method : methods) {
            if (!resolver.resolve(method, headers)) continue;
            resolved.add(method);
        }
        return resolved.toArray(new Method[0]);
    }

    private boolean matchParameters(MediaType acceptedMediaType, MediaType producableMediaType) {
        for (String name : producableMediaType.getParameters().keySet()) {
            String s1 = producableMediaType.getParameter(name);
            String s2 = acceptedMediaType.getParameter(name);
            if (!StringUtils.hasText((String)s1) || !StringUtils.hasText((String)s2) || s1.equalsIgnoreCase(s2)) continue;
            return false;
        }
        return true;
    }

    private void configureResourceForByteRangeRequest(RangeableResource resource, HttpHeaders headers) {
        if (headers.containsKey((Object)"Range")) {
            resource.setRange(headers.getFirst("Range"));
        }
    }

    private int indexOfContentArg(Class<?>[] paramTypes) {
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!InputStream.class.equals(paramTypes[i]) && !Resource.class.equals(paramTypes[i])) continue;
            return i;
        }
        return 0;
    }

    private Resource findStoredRendition(AssociatedStoreResource storeResource, MediaType acceptedMimeType) {
        RenderedResource storedRenditionResource = null;
        Object entity = storeResource.getAssociation();
        for (ContentProperty contentProperty : this.mappingContext.getContentProperties(entity.getClass())) {
            Object candidateMimeType = contentProperty.getMimeType(entity);
            if (candidateMimeType == null) continue;
            String strCandidateMimeType = candidateMimeType.toString();
            try {
                MediaType candidateType = MediaType.parseMediaType((String)strCandidateMimeType);
                if (!acceptedMimeType.includes(candidateType) || !this.matchParameters(acceptedMimeType, candidateType)) continue;
                ContentStore store = (ContentStore)storeResource.getStoreInfo().getImplementation(ContentStore.class);
                storedRenditionResource = new RenderedResource(store.getContent(entity, PropertyPath.from((String)contentProperty.getContentPropertyPath())), (Resource)storeResource);
                break;
            }
            catch (InvalidMediaTypeException invalidMediaTypeException) {
            }
        }
        return storedRenditionResource;
    }

    public static StoreExportedMethodsMap getExportedMethodsFor(Class<? extends Store> storeInterfaceClass, PropertyPath path, ContentPropertyToExportedContext exportContext) {
        StoreExportedMethodsMap exportMap = storeExportedMethods.get(storeInterfaceClass.getCanonicalName() + "#" + path.toString());
        if (exportMap == null) {
            storeExportedMethods.put(storeInterfaceClass.getCanonicalName() + "#" + path.toString(), new StoreExportedMethodsMap(storeInterfaceClass, path, exportContext));
            exportMap = storeExportedMethods.get(storeInterfaceClass.getCanonicalName() + "#" + path.toString());
        }
        return exportMap;
    }

    public static boolean isClientAbortException(Exception e) {
        if (e.getClass().getSimpleName().equals("ClientAbortException")) {
            return true;
        }
        return e instanceof AsyncRequestNotUsableException && e.getCause().getClass().getSimpleName().equals("ClientAbortException");
    }

    public static class StoreExportedMethodsMap {
        private static Method[] SETCONTENT_METHODS_3x = null;
        private static Method[] SETCONTENT_METHODS_2x = null;
        private static Method[] UNSETCONTENT_METHODS_3x = null;
        private static Method[] UNSETCONTENT_METHODS_2x = null;
        private static Method[] GETCONTENT_METHODS = null;
        private Class<? extends Store> storeInterface;
        private PropertyPath path;
        private Method[] getContentMethods;
        private Method[] setContentMethods;
        private Method[] unsetContentMethods;

        public StoreExportedMethodsMap(Class<? extends Store> storeInterface, PropertyPath path, ContentPropertyToExportedContext exportContext) {
            this.storeInterface = storeInterface;
            this.path = path;
            this.getContentMethods = this.calculateExports(GETCONTENT_METHODS, path, exportContext);
            if (org.springframework.content.commons.store.ContentStore.class.isAssignableFrom(storeInterface)) {
                this.setContentMethods = this.calculateExports(SETCONTENT_METHODS_3x, path, exportContext);
                this.unsetContentMethods = this.calculateExports(UNSETCONTENT_METHODS_3x, path, exportContext);
            } else {
                this.setContentMethods = this.calculateExports(SETCONTENT_METHODS_2x, path, exportContext);
                this.unsetContentMethods = this.calculateExports(UNSETCONTENT_METHODS_2x, path, exportContext);
            }
        }

        public Method[] getContentMethods() {
            return this.getContentMethods;
        }

        public Method[] setContentMethods() {
            return this.setContentMethods;
        }

        public Method[] unsetContentMethods() {
            return this.unsetContentMethods;
        }

        private Method[] calculateExports(Method[] storeMethods, PropertyPath path, ContentPropertyToExportedContext exportContext) {
            ArrayList<Method> exportedMethods = new ArrayList<Method>();
            exportedMethods.addAll(Arrays.asList(storeMethods));
            ArrayList<Method> unexportedMethods = new ArrayList<Method>();
            for (Method m : exportedMethods) {
                for (Method dm : this.storeInterface.getDeclaredMethods()) {
                    List<String> paths;
                    RestResource r;
                    if (dm.isBridge() || !dm.getName().equals(m.getName()) || !this.argsMatch(dm, m) || (r = dm.getAnnotation(RestResource.class)) == null || r.exported() || !(paths = Arrays.asList(r.paths())).contains("*") && !paths.contains(path.getName())) continue;
                    unexportedMethods.add(m);
                }
            }
            Pair types = StoreInterfaceUtils.getStoreTypes(this.storeInterface);
            ((Optional)types.getFirst()).ifPresent(clazz -> {
                if (!exportContext.getMappings((Class)((Optional)types.getFirst()).get()).get(path.getName()).booleanValue()) {
                    unexportedMethods.addAll(Arrays.asList(storeMethods));
                }
            });
            for (Method unexportedMethod : unexportedMethods) {
                exportedMethods.remove(unexportedMethod);
            }
            return exportedMethods.toArray(new Method[0]);
        }

        private boolean argsMatch(Method dm, Method m) {
            if (m.getParameterTypes().length != dm.getParameterTypes().length) {
                return false;
            }
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                if (m.getParameterTypes()[i].isAssignableFrom(dm.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }

        static {
            SETCONTENT_METHODS_3x = new Method[]{ReflectionUtils.findMethod(org.springframework.content.commons.store.ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, PropertyPath.class, InputStream.class, SetContentParams.class}), ReflectionUtils.findMethod(org.springframework.content.commons.store.ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, PropertyPath.class, Resource.class})};
            SETCONTENT_METHODS_2x = new Method[]{ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, PropertyPath.class, InputStream.class, org.springframework.content.commons.repository.SetContentParams.class}), ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, PropertyPath.class, Resource.class})};
            UNSETCONTENT_METHODS_3x = new Method[]{ReflectionUtils.findMethod(org.springframework.content.commons.store.ContentStore.class, (String)"unsetContent", (Class[])new Class[]{Object.class, PropertyPath.class, org.springframework.content.commons.store.UnsetContentParams.class})};
            UNSETCONTENT_METHODS_2x = new Method[]{ReflectionUtils.findMethod(ContentStore.class, (String)"unsetContent", (Class[])new Class[]{Object.class, PropertyPath.class, UnsetContentParams.class})};
            GETCONTENT_METHODS = new Method[]{ReflectionUtils.findMethod(ContentStore.class, (String)"getContent", (Class[])new Class[]{Object.class, PropertyPath.class})};
        }
    }
}

