/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers.resolvers;

import internal.org.springframework.content.rest.controllers.ResourceNotFoundException;
import internal.org.springframework.content.rest.controllers.resolvers.EntityResolution;
import internal.org.springframework.content.rest.controllers.resolvers.EntityResolver;
import internal.org.springframework.content.rest.utils.RepositoryUtils;
import internal.org.springframework.content.rest.utils.StoreUtils;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DefaultEntityResolver
implements EntityResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEntityResolver.class);
    private static boolean ROOT_RESOURCE_INFORMATION_CLASS_PRESENT = false;
    private ApplicationContext context;
    private Repositories repositories;
    private Stores stores;
    private ConversionService converters;
    private String mapping;
    private MappingContext mappingContext;

    public DefaultEntityResolver(ApplicationContext context, Repositories repositories, Stores stores, ConversionService converters, String mapping, MappingContext mappingContext) {
        this.context = context;
        this.repositories = repositories;
        this.stores = stores;
        this.converters = converters;
        this.mapping = mapping;
        this.mappingContext = mappingContext;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }

    @Override
    public EntityResolution resolve(String pathInfo) {
        AntPathMatcher matcher = new AntPathMatcher();
        Map variables = matcher.extractUriTemplateVariables(this.mapping, pathInfo);
        String repository = (String)variables.get("repository");
        String id = (String)variables.get("id");
        String[] pathSegments = pathInfo.split("/");
        String store = pathSegments[1];
        StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(store));
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Object domainObj = null;
        try {
            try {
                domainObj = this.findOne(this.repositories, info, info.getDomainObjectClass(), repository, (Serializable)((Object)id));
            }
            catch (IllegalArgumentException iae) {
                domainObj = this.findOne(this.repositories, info, repository, id);
            }
        }
        catch (HttpRequestMethodNotSupportedException e) {
            throw new ResourceNotFoundException();
        }
        String propertyPath = matcher.extractPathWithinPattern(this.mapping, pathInfo);
        if (!StringUtils.hasText((String)propertyPath)) {
            ContentProperty property = this.selectPrimaryContentProperty(info);
            propertyPath = property.getContentPropertyPath();
        }
        return new EntityResolution(domainObj, PropertyPath.from((String)propertyPath));
    }

    @Override
    public boolean hasPropertyFor(String pathInfo) {
        AntPathMatcher matcher = new AntPathMatcher();
        Map variables = matcher.extractUriTemplateVariables(this.mapping, pathInfo);
        String repository = (String)variables.get("repository");
        String id = (String)variables.get("id");
        String[] pathSegments = pathInfo.split("/");
        String store = pathSegments[1];
        StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(store));
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        String propertyPath = matcher.extractPathWithinPattern(this.mapping, pathInfo);
        if (propertyPath == null) {
            propertyPath = "";
        }
        return this.mappingContext.getContentProperty(info.getDomainObjectClass(), propertyPath) != null;
    }

    public Object findOne(Repositories repositories, StoreInfo info, String repository, String id) throws HttpRequestMethodNotSupportedException {
        RepositoryInformation ri = RepositoryUtils.findRepositoryInformation(repositories, repository);
        if (ri == null) {
            throw new ResourceNotFoundException();
        }
        Class domainObjClazz = ri.getDomainType();
        return this.findOne(repositories, info, domainObjClazz, repository, (Serializable)((Object)id));
    }

    public Object findOne(Repositories repositories, StoreInfo info, Class<?> domainObjClass, String repository, Serializable id) throws HttpRequestMethodNotSupportedException {
        Optional<Object> domainObj = Optional.empty();
        if (ROOT_RESOURCE_INFORMATION_CLASS_PRESENT) {
            try {
                RepositoryInvoker invoker = this.resolveRootResourceInformation(info, repository, id, new ModelAndViewContainer(), new FakeWebBinderFactory());
                if (invoker != null) {
                    domainObj = invoker.invokeFindById((Object)id);
                }
                logger.warn("Could not resolve RootResourceInformation");
            }
            catch (ConverterNotFoundException e) {
                logger.debug("invoking Repository findById(id) method failed");
                domainObj = this.findOneByReflection(repositories, domainObjClass, id);
            }
            catch (AccessDeniedException ace) {
                logger.debug("invoking Repository findById(id) method threw AccessDeniedException");
                throw ace;
            }
            catch (Exception e) {
                logger.error("invoking Repository findById(id) method threw exception", e.getCause());
            }
        } else {
            domainObj = this.findOneByReflection(repositories, domainObjClass, id);
        }
        return domainObj.orElseThrow(ResourceNotFoundException::new);
    }

    public Optional<Object> findOneByReflection(Repositories repositories, Class<?> domainObjClass, Serializable id) throws HttpRequestMethodNotSupportedException {
        RepositoryInformation ri = RepositoryUtils.findRepositoryInformation(repositories, domainObjClass);
        if (ri == null) {
            throw new ResourceNotFoundException();
        }
        Class domainObjClazz = ri.getDomainType();
        Class idClazz = ri.getIdType();
        Optional findOneMethod = ri.getCrudMethods().getFindOneMethod();
        if (!findOneMethod.isPresent()) {
            throw new HttpRequestMethodNotSupportedException("fineOne");
        }
        Serializable oid = id;
        if (this.converters.canConvert(String.class, idClazz)) {
            oid = (Serializable)this.converters.convert((Object)id, idClazz);
        }
        return (Optional)ReflectionUtils.invokeMethod((Method)((Method)findOneMethod.get()), repositories.getRepositoryFor(domainObjClazz).get(), (Object[])new Object[]{oid});
    }

    private RepositoryInvoker resolveRootResourceInformation(StoreInfo info, String repository, Serializable id, ModelAndViewContainer mavContainer, WebDataBinderFactory binderFactory) throws Exception {
        Method m = ReflectionUtils.findMethod(RepositoryEntityControllerFacade.class, (String)"getItemResource", (Class[])new Class[]{RootResourceInformation.class});
        MethodParameter repoRequestMethodParameter = new MethodParameter(m, 0);
        RepositoryInformation ri = RepositoryUtils.findRepositoryInformation(this.repositories, info.getDomainObjectClass());
        if (ri == null) {
            ri = RepositoryUtils.findRepositoryInformation(this.repositories, repository);
        }
        if (ri == null) {
            throw new IllegalStateException(String.format("Unable to resolve root resource information for ", String.join((CharSequence)"/", repository, id.toString())));
        }
        String repo = RepositoryUtils.repositoryPath(ri);
        String repoUri = String.format("/%s/%s", repo, id);
        BaseUri baseUri = (BaseUri)this.context.getBean(BaseUri.class);
        if (!baseUri.equals(BaseUri.NONE)) {
            repoUri = String.format("%s%s", baseUri.getUri().toString(), repoUri);
        }
        NativeWebRequest repoRequestFacade = DefaultEntityResolver.nativeWebRequestForGetItemResource(repoUri);
        RootResourceInformationHandlerMethodArgumentResolver rootResourceInfoResolver = (RootResourceInformationHandlerMethodArgumentResolver)this.context.getBean(RootResourceInformationHandlerMethodArgumentResolver.class);
        RootResourceInformation rri = rootResourceInfoResolver.resolveArgument(repoRequestMethodParameter, mavContainer, repoRequestFacade, binderFactory);
        return rri.getInvoker();
    }

    private ContentProperty selectPrimaryContentProperty(StoreInfo info) {
        ContentProperty contentProperty = null;
        try {
            contentProperty = (ContentProperty)this.mappingContext.getContentProperties(info.getDomainObjectClass()).iterator().next();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return contentProperty;
    }

    public static NativeWebRequest nativeWebRequestForGetItemResource(String pathInfo) {
        return new GetItemResourceNativeWebRequest(pathInfo);
    }

    static {
        try {
            ROOT_RESOURCE_INFORMATION_CLASS_PRESENT = DefaultEntityResolver.class.getClassLoader().loadClass("org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static class FakeWebBinderFactory
    implements WebDataBinderFactory {
        public WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
            return null;
        }
    }

    public static class RepositoryEntityControllerFacade {
        @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.GET})
        public ResponseEntity<EntityModel<?>> getItemResource(@QuerydslPredicate RootResourceInformation resourceInformation) {
            return null;
        }
    }

    public static class GetItemResourceNativeWebRequest
    implements NativeWebRequest {
        private String pathInfo;

        public GetItemResourceNativeWebRequest(String pathInfo) {
            this.pathInfo = pathInfo;
        }

        public String getHeader(String headerName) {
            return null;
        }

        public String[] getHeaderValues(String headerName) {
            return null;
        }

        public Iterator<String> getHeaderNames() {
            return null;
        }

        public String getParameter(String paramName) {
            return null;
        }

        public String[] getParameterValues(String paramName) {
            return null;
        }

        public Iterator<String> getParameterNames() {
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.emptyMap();
        }

        public Locale getLocale() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public boolean checkNotModified(long lastModifiedTimestamp) {
            return false;
        }

        public boolean checkNotModified(String etag) {
            return false;
        }

        public boolean checkNotModified(String etag, long lastModifiedTimestamp) {
            return false;
        }

        public String getDescription(boolean includeClientInfo) {
            return null;
        }

        public Object getAttribute(String name, int scope) {
            return null;
        }

        public void setAttribute(String name, Object value, int scope) {
        }

        public void removeAttribute(String name, int scope) {
        }

        public String[] getAttributeNames(int scope) {
            return null;
        }

        public void registerDestructionCallback(String name, Runnable callback, int scope) {
        }

        public Object resolveReference(String key) {
            return null;
        }

        public String getSessionId() {
            return null;
        }

        public Object getSessionMutex() {
            return null;
        }

        public Object getNativeRequest() {
            return null;
        }

        public Object getNativeResponse() {
            return null;
        }

        public <T> T getNativeRequest(Class<T> requiredType) {
            return (T)new GetItemResourceHttpServletRequest(this.pathInfo);
        }

        public <T> T getNativeResponse(Class<T> requiredType) {
            return null;
        }
    }

    public static class GetItemResourceHttpServletRequest
    implements HttpServletRequest {
        private String pathInfo;

        public GetItemResourceHttpServletRequest(String pathInfo) {
            this.pathInfo = pathInfo;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        }

        public int getContentLength() {
            return 0;
        }

        public long getContentLengthLong() {
            return 0L;
        }

        public String getContentType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getParameter(String name) {
            return null;
        }

        public Enumeration<String> getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String name) {
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public void setAttribute(String name, Object o) {
        }

        public void removeAttribute(String name) {
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return null;
        }

        public boolean isSecure() {
            return false;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public String getLocalName() {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public AsyncContext startAsync() throws IllegalStateException {
            return null;
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            return null;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public DispatcherType getDispatcherType() {
            return null;
        }

        public String getRequestId() {
            return null;
        }

        public String getProtocolRequestId() {
            return null;
        }

        public ServletConnection getServletConnection() {
            return null;
        }

        public String getAuthType() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String name) {
            return 0L;
        }

        public String getHeader(String name) {
            return null;
        }

        public Enumeration<String> getHeaders(String name) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return null;
        }

        public int getIntHeader(String name) {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getContextPath() {
            return "";
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getRequestURI() {
            return this.pathInfo;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getServletPath() {
            return "";
        }

        public HttpSession getSession(boolean create) {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public String changeSessionId() {
            return null;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            return false;
        }

        public void login(String username, String password) throws ServletException {
        }

        public void logout() throws ServletException {
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return null;
        }

        public Part getPart(String name) throws IOException, ServletException {
            return null;
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
            return null;
        }
    }
}

