/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.io;

import internal.org.springframework.content.rest.io.StoreResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.springframework.content.commons.io.DeletableResource;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class StoreResourceImpl
implements Resource,
StoreResource {
    private Resource delegate;
    private StoreInfo storeInfo;

    public StoreResourceImpl(StoreInfo storeInfo, Resource delegate) {
        Assert.notNull((Object)storeInfo, (String)"storeInfo cannot be null");
        Assert.notNull((Object)delegate, (String)"delegate cannot be null");
        this.storeInfo = storeInfo;
        this.delegate = delegate;
    }

    @Override
    public StoreInfo getStoreInfo() {
        return this.storeInfo;
    }

    @Override
    public Object getETag() {
        try {
            return this.lastModified();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public MediaType getMimeType() {
        String mimeType = null;
        try {
            mimeType = Files.probeContentType(Paths.get(this.getFilename(), new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return MediaType.valueOf((String)(mimeType != null ? mimeType : ""));
    }

    @Override
    public boolean isRenderableAs(MimeType mimeType) {
        return false;
    }

    @Override
    public InputStream renderAs(MimeType mimeType) {
        throw new UnsupportedOperationException("not implemented");
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean isReadable() {
        return this.delegate.isReadable();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public boolean isFile() {
        return this.delegate.isFile();
    }

    public URL getURL() throws IOException {
        return this.delegate.getURL();
    }

    public URI getURI() throws IOException {
        return this.delegate.getURI();
    }

    public File getFile() throws IOException {
        return this.delegate.getFile();
    }

    public ReadableByteChannel readableChannel() throws IOException {
        return this.delegate.readableChannel();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public long lastModified() throws IOException {
        return this.delegate.lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.delegate.createRelative(relativePath);
    }

    public String getFilename() {
        return this.delegate.getFilename();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public boolean isWritable() {
        return ((WritableResource)this.delegate).isWritable();
    }

    public OutputStream getOutputStream() throws IOException {
        return ((WritableResource)this.delegate).getOutputStream();
    }

    public WritableByteChannel writableChannel() throws IOException {
        return ((WritableResource)this.delegate).writableChannel();
    }

    public void delete() throws IOException {
        ((DeletableResource)this.delegate).delete();
    }
}

