/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappingcontext;

import internal.org.springframework.content.rest.mappingcontext.RestResourceMappingBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.content.commons.mappingcontext.ClassVisitor;
import org.springframework.content.commons.mappingcontext.ClassWalker;

public class ContentPropertyToExportedContext {
    private Map<Class<?>, Map<String, Boolean>> mappings = new HashMap();

    public Map<String, Boolean> getMappings(Class<?> domainClass) {
        Map<String, Boolean> mappings = this.mappings.get(domainClass);
        if (mappings == null) {
            mappings = this.resolveMappings(domainClass);
        }
        return mappings;
    }

    private Map<String, Boolean> resolveMappings(Class<?> domainClass) {
        RestResourceMappingBuilder visitor = new RestResourceMappingBuilder(restResource -> String.valueOf(restResource.exported()));
        ClassWalker walker = new ClassWalker((ClassVisitor)visitor);
        walker.accept(domainClass);
        Map<String, String> mappings = visitor.getMappings();
        this.mappings.put(domainClass, this.collapse(mappings));
        return this.mappings.get(domainClass);
    }

    private Map<String, Boolean> collapse(Map<String, String> mappings) {
        HashMap<String, Boolean> collapsedMappings = new HashMap<String, Boolean>();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            Boolean exported = true;
            String[] segments = entry.getValue().split("/");
            for (int i = 0; i < segments.length; ++i) {
                exported = exported & this.valueOf(segments[i]);
            }
            collapsedMappings.put(entry.getKey(), exported);
        }
        return collapsedMappings;
    }

    private Boolean valueOf(String segment) {
        if (segment.toLowerCase(Locale.ROOT).equals("false")) {
            return false;
        }
        return true;
    }
}

