/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappings;

import internal.org.springframework.content.rest.annotations.ContentRestController;
import internal.org.springframework.content.rest.controllers.resolvers.EntityResolvers;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyRequest;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToRequestMappingContext;
import internal.org.springframework.content.rest.mappings.CorsConfigurationBuilder;
import internal.org.springframework.content.rest.mappings.StoreAwareHandlerMapping;
import internal.org.springframework.content.rest.utils.StoreUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.util.UrlPathHelper;

public class ContentHandlerMapping
extends StoreAwareHandlerMapping {
    private static MediaType hal = MediaType.parseMediaType((String)"application/hal+json");
    private static MediaType json = MediaType.parseMediaType((String)"application/json");
    private RestConfiguration.Exclusions exclusions = null;
    private Stores contentStores;
    private EntityResolvers entityResolvers = null;
    private final ContentPropertyToRequestMappingContext requestMappingContext;

    public ContentHandlerMapping(Stores contentStores, EntityResolvers entityResolvers, ContentPropertyToRequestMappingContext requestMappingContext, RestConfiguration config) {
        super(config);
        this.initExclusions(this.exclusions, config);
        this.contentStores = contentStores;
        this.entityResolvers = entityResolvers;
        this.requestMappingContext = requestMappingContext;
        this.setOrder(0x7FFFFF37);
    }

    private void initExclusions(RestConfiguration.Exclusions exclusions, RestConfiguration config) {
        this.exclusions = config.shortcutExclusions();
        if (this.exclusions.size() == 0) {
            this.exclusions.exclude("GET", MediaType.parseMediaType((String)"application/json")).exclude("GET", MediaType.parseMediaType((String)"application/hal+json")).exclude("DELETE", MediaType.parseMediaType((String)"application/json")).exclude("DELETE", MediaType.parseMediaType((String)"application/hal+json")).exclude("PUT", MediaType.parseMediaType((String)"application/json")).exclude("PUT", MediaType.parseMediaType((String)"application/hal+json")).exclude("POST", MediaType.parseMediaType((String)"application/json")).exclude("POST", MediaType.parseMediaType((String)"application/hal+json")).exclude("PATCH", MediaType.parseMediaType((String)"*/*")).exclude("HEAD", MediaType.parseMediaType((String)"*/*"));
        }
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, ContentRestController.class) != null;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        String storeLookupPath = StoreUtils.storeLookupPath(lookupPath, this.getConfiguration().getBaseUri());
        if (storeLookupPath != null) {
            String resolvedContentPropertyPath;
            String resolvedStoreLookupPath;
            String[] path = storeLookupPath.split("/");
            if (path.length < 3) {
                return null;
            }
            StoreInfo info2 = this.contentStores.getStore(Store.class, StoreUtils.withStorePath(path[1]));
            if (info2 != null && (this.isFullyQualifiedContentPropertyRequest(path, info2) ? this.entityResolvers.hasPropertyFor(resolvedStoreLookupPath = ContentPropertyRequest.from(path[1], path[2], resolvedContentPropertyPath = this.requestMappingContext.resolveContentPropertyPath(info2.getDomainObjectClass(), ContentPropertyRequest.from(storeLookupPath).getContentPropertyPath())).getRequestURI()) : this.getConfiguration().shortcutLinks() && info2 != null && !this.isExcludedShortcutContentPropertyRequest(request))) {
                return super.lookupHandlerMethod(lookupPath, request);
            }
        }
        return null;
    }

    protected boolean hasCorsConfigurationSource(Object handler) {
        return true;
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        String storeLookupPath = StoreUtils.storeLookupPath(lookupPath, this.getConfiguration().getBaseUri());
        CorsConfiguration corsConfiguration = super.getCorsConfiguration(handler, request);
        if (storeLookupPath == null) {
            return corsConfiguration;
        }
        String[] path = storeLookupPath.split("/");
        if (path.length < 3) {
            return corsConfiguration;
        }
        StoreInfo info2 = this.contentStores.getStore(Store.class, StoreUtils.withStorePath(path[1]));
        if (info2 == null) {
            return corsConfiguration;
        }
        CorsConfigurationBuilder builder = new CorsConfigurationBuilder();
        CorsConfiguration storeCorsConfiguration = builder.build(info2.getInterface());
        return corsConfiguration == null ? storeCorsConfiguration : corsConfiguration.combine(storeCorsConfiguration);
    }

    private boolean isExcludedShortcutContentPropertyRequest(HttpServletRequest request) {
        String method = request.getMethod();
        List excludedMediaTypes = (List)this.exclusions.get(method);
        if (excludedMediaTypes == null) {
            return false;
        }
        String mediaTypes = "*/*";
        if ("GET".equals(method) || "DELETE".equals(method)) {
            mediaTypes = request.getHeader("Accept");
        } else if ("PUT".equals(method) || "POST".equals(method)) {
            mediaTypes = request.getHeader("Content-Type");
        }
        List acceptedMediaTypes = MediaType.parseMediaTypes((String)mediaTypes);
        for (MediaType excludedMediaType : excludedMediaTypes) {
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!excludedMediaType.includes(acceptedMediaType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFullyQualifiedContentPropertyRequest(String[] path, StoreInfo info2) {
        return (AssociativeStore.class.isAssignableFrom(info2.getInterface()) || org.springframework.content.commons.store.AssociativeStore.class.isAssignableFrom(info2.getInterface())) && path.length >= 4;
    }

    protected void detectHandlerMethods(Object handler) {
        super.detectHandlerMethods(handler);
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        StoreType typeAnnotation = (StoreType)AnnotationUtils.findAnnotation((Method)method, StoreType.class);
        if (typeAnnotation != null) {
            return new StoreCondition(typeAnnotation, this.contentStores, method, this.getConfiguration().getBaseUri());
        }
        return null;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface StoreType {
        public String value() default "store";
    }

    public static class StoreCondition
    implements RequestCondition<StoreCondition> {
        private String storeType = "store";
        private Stores stores;
        private Method method;
        private URI baseUri;

        public StoreCondition(StoreType typeAnnotation, Stores stores, Method method, URI baseUri) {
            this.storeType = typeAnnotation.value();
            this.stores = stores;
            this.method = method;
            this.baseUri = baseUri;
        }

        public StoreCondition combine(StoreCondition other) {
            throw new UnsupportedOperationException();
        }

        public StoreCondition getMatchingCondition(HttpServletRequest request) {
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String storeLookupPath = StoreUtils.storeLookupPath(path, this.baseUri);
            String[] segments = storeLookupPath.split("/");
            if (segments.length < 3) {
                return null;
            }
            StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(segments[1]));
            if (info != null && (Store.class.isAssignableFrom(info.getInterface()) && "store".equals(this.storeType) || ContentStore.class.isAssignableFrom(info.getInterface()) && "contentstore".equals(this.storeType))) {
                return this;
            }
            return null;
        }

        public int compareTo(StoreCondition other, HttpServletRequest request) {
            if (this.isMappingForRequest(request) && !other.isMappingForRequest(request)) {
                return 1;
            }
            if (!this.isMappingForRequest(request) && other.isMappingForRequest(request)) {
                return -1;
            }
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String storeLookupPath = StoreUtils.storeLookupPath(path, this.baseUri);
            String filename = FilenameUtils.getName((String)storeLookupPath);
            String extension = FilenameUtils.getExtension((String)filename);
            if (extension != null && "store".equals(this.storeType)) {
                return -1;
            }
            if (extension != null && "contentstore".equals(this.storeType)) {
                return 1;
            }
            return 0;
        }

        public boolean isMappingForRequest(HttpServletRequest request) {
            String path = new UrlPathHelper().getPathWithinApplication(request);
            String storeLookupPath = StoreUtils.storeLookupPath(path, this.baseUri);
            String[] segments = storeLookupPath.split("/");
            if (segments.length < 3) {
                return false;
            }
            StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(segments[1]));
            return info != null && Store.class.isAssignableFrom(info.getInterface()) && "store".equals(this.storeType) || ContentStore.class.isAssignableFrom(info.getInterface()) && "contentstore".equals(this.storeType);
        }
    }
}

