/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.mappings;

import java.util.Collection;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.cors.CorsConfiguration;

public class CorsConfigurationBuilder {
    public CorsConfiguration build(Class<?> storeInterface) {
        String allowCredentials;
        CorsConfiguration config = new CorsConfiguration();
        CrossOrigin annotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation(storeInterface, CrossOrigin.class);
        if (annotation == null) {
            return null;
        }
        for (String string : annotation.origins()) {
            config.addAllowedOrigin(string);
        }
        if (CollectionUtils.isEmpty((Collection)config.getAllowedOrigins())) {
            config.applyPermitDefaultValues();
        }
        for (String string : annotation.allowedHeaders()) {
            config.addAllowedHeader(string);
        }
        for (String string : annotation.exposedHeaders()) {
            config.addExposedHeader(string);
        }
        for (String string : annotation.methods()) {
            config.addAllowedMethod(string.name());
        }
        if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
            for (String string : HttpMethod.values()) {
                config.addAllowedMethod((HttpMethod)string);
            }
        }
        if ("true".equalsIgnoreCase(allowCredentials = annotation.allowCredentials())) {
            config.setAllowCredentials(Boolean.valueOf(true));
        } else if ("false".equalsIgnoreCase(allowCredentials)) {
            config.setAllowCredentials(Boolean.valueOf(false));
        } else if (!allowCredentials.isEmpty()) {
            throw new IllegalStateException("@CrossOrigin's allowCredentials value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowCredentials + "]");
        }
        if (annotation.maxAge() >= 0L) {
            config.setMaxAge(Long.valueOf(annotation.maxAge()));
        }
        return config;
    }
}

