/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.extensions.entitycontent;

import internal.org.springframework.content.rest.contentservice.ContentStoreContentService;
import internal.org.springframework.content.rest.controllers.BadRequestException;
import internal.org.springframework.content.rest.controllers.MethodNotAllowedException;
import internal.org.springframework.content.rest.controllers.resolvers.AssociativeStoreResourceResolver;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToExportedContext;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToRequestMappingContext;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import internal.org.springframework.content.rest.utils.ControllerUtils;
import internal.org.springframework.content.rest.utils.StoreUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.UriTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.util.UrlPathHelper;

@RepositoryRestController
public class RepositoryEntityMultipartController {
    private static final String ENTITY_POST_MAPPING = "/{repository}";
    private RestConfiguration restConfig;
    private RepositoryInvokerFactory repoInvokerFactory;
    private ContentPropertyToRequestMappingContext requestMappingContext;
    private MappingContext mappingContext;
    private ContentPropertyToExportedContext exportedMappingContext;
    private StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;
    private Stores stores;
    private SelfLinkProvider selfLinkProvider;
    private HttpHeadersPreparer headersPreparer;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryEntityMultipartController(RestConfiguration restConfig, RepositoryInvokerFactory repoInvokerFactory, ContentPropertyToRequestMappingContext requestMappingContext, SelfLinkProvider selfLinkProvider, Stores stores, MappingContext mappingContext, ContentPropertyToExportedContext exportedMappingContext, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler, @Qualifier(value="entityMultipartHttpMessageConverterConfigurer") RepositoryRestConfigurer configurer, HttpHeadersPreparer headersPreparer, ApplicationEventPublisher publisher) {
        this.restConfig = restConfig;
        this.repoInvokerFactory = repoInvokerFactory;
        this.requestMappingContext = requestMappingContext;
        this.selfLinkProvider = selfLinkProvider;
        this.stores = stores;
        this.mappingContext = mappingContext;
        this.exportedMappingContext = exportedMappingContext;
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
        this.headersPreparer = headersPreparer;
        this.publisher = publisher;
    }

    @ResponseBody
    @PostMapping(value={"/{repository}"}, consumes={"multipart/form-data"})
    public ResponseEntity<RepresentationModel<?>> createEntityAndContent(RootResourceInformation repoInfo, PersistentEntityResource payload, PersistentEntityResourceAssembler assembler, @PathVariable(value="repository") String repository, @RequestHeader HttpHeaders headers, MultipartHttpServletRequest req, HttpServletResponse resp) throws IOException, MethodNotAllowedException, HttpRequestMethodNotSupportedException {
        repoInfo.verifySupportedMethod(HttpMethod.POST, ResourceType.COLLECTION);
        Class domainType = repoInfo.getDomainType();
        Object savedEntity = payload.getContent();
        String pathInfo = new UrlPathHelper().getPathWithinApplication((HttpServletRequest)req);
        pathInfo = StoreUtils.storeLookupPath(pathInfo, this.restConfig.getBaseUri());
        String[] pathSegments = pathInfo.split("/");
        if (pathSegments.length < 2) {
            throw new BadRequestException();
        }
        String store = pathSegments[1];
        BeforeCreateEvent beforeCreate = new BeforeCreateEvent(savedEntity);
        this.publisher.publishEvent((ApplicationEvent)beforeCreate);
        savedEntity = this.repoInvokerFactory.getInvokerFor(domainType).invokeSave(savedEntity);
        AfterCreateEvent afterCreate = new AfterCreateEvent(savedEntity);
        this.publisher.publishEvent((ApplicationEvent)afterCreate);
        StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(store));
        if (info != null) {
            ContentStoreContentService service = new ContentStoreContentService(this.restConfig, info, this.repoInvokerFactory.getInvokerFor(domainType), this.mappingContext, this.exportedMappingContext, this.byteRangeRestRequestHandler);
            MultiValueMap files = req.getMultiFileMap();
            for (String path : files.keySet()) {
                MultipartFile file = (MultipartFile)((List)files.get((Object)path)).get(0);
                String resolvedPath = file.getName();
                if (this.requestMappingContext.hasInverseMapping(domainType, file.getName())) {
                    resolvedPath = this.requestMappingContext.getInverseMappings(domainType).get(file.getName());
                }
                Resource storeResource = new AssociativeStoreResourceResolver(this.mappingContext).resolve(new InternalWebRequest(req, resp), info, savedEntity, PropertyPath.from((String)resolvedPath));
                headers.setContentLength(file.getSize());
                service.setContent((HttpServletRequest)req, resp, headers, (Resource)new InputStreamResourceWithFilename(file.getInputStream(), file.getOriginalFilename()), MediaType.parseMediaType((String)file.getContentType()), storeResource);
            }
        }
        Optional<PersistentEntityResource> resource = Optional.ofNullable(assembler.toFullResource(savedEntity));
        headers.setContentType(new MediaType("application", "hal+json"));
        HttpHeaders respHeaders = this.headersPreparer.prepareHeaders(resource);
        String selfLink = this.selfLinkProvider.createSelfLinkFor(savedEntity).withSelfRel().expand(new Object[0]).getHref();
        respHeaders.setLocation(UriTemplate.of((String)selfLink).expand(new Object[0]));
        return ControllerUtils.toResponseEntity(HttpStatus.CREATED, respHeaders, resource);
    }

    private static class InternalWebRequest
    implements NativeWebRequest {
        private final MultipartHttpServletRequest req;
        private final HttpServletResponse resp;

        public InternalWebRequest(MultipartHttpServletRequest req, HttpServletResponse resp) {
            this.req = req;
            this.resp = resp;
        }

        public Object getNativeRequest() {
            return this.req;
        }

        public Object getNativeResponse() {
            return this.resp;
        }

        public <T> T getNativeRequest(Class<T> requiredType) {
            return (T)this.req;
        }

        public <T> T getNativeResponse(Class<T> requiredType) {
            return (T)this.resp;
        }

        public String getHeader(String headerName) {
            return this.req.getHeader(headerName);
        }

        public String[] getHeaderValues(String headerName) {
            throw new UnsupportedOperationException();
        }

        public Iterator<String> getHeaderNames() {
            throw new UnsupportedOperationException();
        }

        public String getParameter(String paramName) {
            throw new UnsupportedOperationException();
        }

        public String[] getParameterValues(String paramName) {
            throw new UnsupportedOperationException();
        }

        public Iterator<String> getParameterNames() {
            throw new UnsupportedOperationException();
        }

        public Map<String, String[]> getParameterMap() {
            throw new UnsupportedOperationException();
        }

        public Locale getLocale() {
            throw new UnsupportedOperationException();
        }

        public String getContextPath() {
            throw new UnsupportedOperationException();
        }

        public String getRemoteUser() {
            throw new UnsupportedOperationException();
        }

        public Principal getUserPrincipal() {
            throw new UnsupportedOperationException();
        }

        public boolean isUserInRole(String role) {
            throw new UnsupportedOperationException();
        }

        public boolean isSecure() {
            throw new UnsupportedOperationException();
        }

        public boolean checkNotModified(long lastModifiedTimestamp) {
            throw new UnsupportedOperationException();
        }

        public boolean checkNotModified(String etag) {
            throw new UnsupportedOperationException();
        }

        public boolean checkNotModified(String etag, long lastModifiedTimestamp) {
            throw new UnsupportedOperationException();
        }

        public String getDescription(boolean includeClientInfo) {
            throw new UnsupportedOperationException();
        }

        public Object getAttribute(String name, int scope) {
            throw new UnsupportedOperationException();
        }

        public void setAttribute(String name, Object value, int scope) {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String name, int scope) {
            throw new UnsupportedOperationException();
        }

        public String[] getAttributeNames(int scope) {
            throw new UnsupportedOperationException();
        }

        public void registerDestructionCallback(String name, Runnable callback, int scope) {
            throw new UnsupportedOperationException();
        }

        public Object resolveReference(String key) {
            throw new UnsupportedOperationException();
        }

        public String getSessionId() {
            throw new UnsupportedOperationException();
        }

        public Object getSessionMutex() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InputStreamResourceWithFilename
    extends InputStreamResource {
        private final String filename;

        public InputStreamResourceWithFilename(InputStream inputStream, String filename) {
            super(inputStream);
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

