/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.versioning;

import internal.org.springframework.content.rest.utils.ControllerUtils;
import internal.org.springframework.content.rest.utils.RepositoryUtils;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.utils.ReflectionService;
import org.springframework.content.commons.utils.ReflectionServiceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;
import org.springframework.versions.LockingAndVersioningRepository;
import org.springframework.versions.VersionInfo;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
public class LockingAndVersioningRestController {
    private static final String ENTITY_LOCK_MAPPING = "/{repository}/{id}/lock";
    private static final String ENTITY_VERSION_MAPPING = "/{repository}/{id}/version";
    private static final String ENTITY_FINDALLLATESTVERSION_MAPPING = "/{repository}/findAllVersionsLatest";
    private static final String FINDALLVERSIONS_METHOD_MAPPING = "/{repository}/{id}/findAllVersions";
    private static Method LOCK_METHOD = null;
    private static Method UNLOCK_METHOD = null;
    private static Method VERSION_METHOD = null;
    private static Method FINDALLLATESTVERSION_METHOD = null;
    private static Method FINDALLVERSIONS_METHOD = null;
    private final Repositories repositories;
    private final PagedResourcesAssembler<Object> pagedResourcesAssembler;
    private ReflectionService reflectionService;

    @Autowired
    public LockingAndVersioningRestController(Repositories repositories, PagedResourcesAssembler<Object> assembler) {
        this.repositories = repositories;
        this.pagedResourcesAssembler = assembler;
        this.reflectionService = new ReflectionServiceImpl();
    }

    public void setReflectionService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/lock"}, method={RequestMethod.PUT})
    public ResponseEntity<EntityModel<?>> lock(RootResourceInformation repoInfo, @PathVariable(value="repository") String repository, @PathVariable(value="id") String id, Principal principal) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        if ((domainObj = ReflectionUtils.invokeMethod((Method)LOCK_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj})) != null) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/lock"}, method={RequestMethod.DELETE})
    public ResponseEntity<EntityModel<?>> unlock(RootResourceInformation repoInfo, @PathVariable(value="repository") String repository, @PathVariable(value="id") String id, Principal principal) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        if ((domainObj = ReflectionUtils.invokeMethod((Method)UNLOCK_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj})) != null) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/version"}, method={RequestMethod.PUT})
    public ResponseEntity<EntityModel<?>> version(RootResourceInformation repoInfo, @PathVariable(value="repository") String repository, @PathVariable(value="id") String id, @RequestBody VersionInfo info, Principal principal, PersistentEntityResourceAssembler assembler) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        if ((domainObj = ReflectionUtils.invokeMethod((Method)VERSION_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj, info})) != null) {
            return new ResponseEntity((Object)assembler.toFullResource(domainObj), (HttpStatusCode)HttpStatus.OK);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).build();
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/findAllVersionsLatest"}, method={RequestMethod.GET})
    public CollectionModel<?> findAllLatestVersion(RootResourceInformation repoInfo, PersistentEntityResourceAssembler assembler, @PathVariable(value="repository") String repository) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        RepositoryInformation repositoryInfo = RepositoryUtils.findRepositoryInformation(this.repositories, repository);
        Class domainType = repositoryInfo.getDomainType();
        List results = (List)ReflectionUtils.invokeMethod((Method)FINDALLLATESTVERSION_METHOD, this.repositories.getRepositoryFor(domainType).get(), (Object[])new Object[]{domainType});
        ResourceMetadata metadata = repoInfo.getResourceMetadata();
        CollectionModel<?> result = ControllerUtils.toCollectionModel(results, this.pagedResourcesAssembler, assembler, metadata.getDomainType());
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}/{id}/findAllVersions"}, method={RequestMethod.GET})
    public CollectionModel<?> findAllVersions(RootResourceInformation repoInfo, PersistentEntityResourceAssembler assembler, @PathVariable(value="repository") String repository, @PathVariable(value="id") String id, Sort sort) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Object domainObj = repoInfo.getInvoker().invokeFindById((Object)id).get();
        List results = (List)ReflectionUtils.invokeMethod((Method)FINDALLVERSIONS_METHOD, this.repositories.getRepositoryFor(domainObj.getClass()).get(), (Object[])new Object[]{domainObj, sort});
        ResourceMetadata metadata = repoInfo.getResourceMetadata();
        CollectionModel<?> result = ControllerUtils.toCollectionModel(results, this.pagedResourcesAssembler, assembler, metadata.getDomainType());
        return result;
    }

    static {
        LOCK_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"lock", (Class[])new Class[]{Object.class});
        UNLOCK_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"unlock", (Class[])new Class[]{Object.class});
        VERSION_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"version", (Class[])new Class[]{Object.class, VersionInfo.class});
        FINDALLLATESTVERSION_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"findAllVersionsLatest", (Class[])new Class[]{Class.class});
        FINDALLVERSIONS_METHOD = ReflectionUtils.findMethod(LockingAndVersioningRepository.class, (String)"findAllVersions", (Class[])new Class[]{Object.class, Sort.class});
    }
}

