/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

class PartialContentInputStream
extends InputStream {
    private final InputStream delegate;
    private final long totalLength;
    private final long rangeStart;
    private final long rangeEnd;
    private long currentPosition = 0L;
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("\\Abytes (?<firstPos>[0-9]+)-(?<lastPos>[0-9]+)/(?<completeLength>[0-9]+|\\*)\\Z");

    public static InputStream fromContentRange(InputStream delegate, String contentRange) {
        Assert.notNull((Object)delegate, (String)"delegate");
        Assert.notNull((Object)contentRange, (String)"contentRange");
        Matcher contentRangeMatch = CONTENT_RANGE_PATTERN.matcher(contentRange);
        if (!contentRangeMatch.matches()) {
            throw new IllegalArgumentException("Content-Range '%s' is not RFC9110 compliant.".formatted(contentRange));
        }
        long rangeStart = Long.parseUnsignedLong(contentRangeMatch.group("firstPos"));
        long rangeEnd = Long.parseUnsignedLong(contentRangeMatch.group("lastPos")) + 1L;
        String completeLengthStr = contentRangeMatch.group("completeLength");
        long completeLength = Objects.equals(completeLengthStr, "*") ? rangeEnd : Long.parseUnsignedLong(completeLengthStr);
        return new PartialContentInputStream(delegate, completeLength, rangeStart, rangeEnd);
    }

    public PartialContentInputStream(InputStream delegate, long totalLength, long rangeStart, long rangeEndExclusive) {
        this.delegate = delegate;
        if (totalLength < rangeEndExclusive) {
            totalLength = rangeEndExclusive;
        }
        this.totalLength = totalLength;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEndExclusive;
    }

    private BlockState blockState(long length) {
        if (this.currentPosition + length < 0L) {
            length = Long.MAX_VALUE - this.currentPosition;
        }
        long startPosition = this.currentPosition;
        long endPosition = Math.min(this.currentPosition + length, this.totalLength);
        if (endPosition < this.rangeStart || startPosition >= this.rangeEnd) {
            return new BlockState(false, startPosition, endPosition);
        }
        if (startPosition < this.rangeStart) {
            return new BlockState(false, startPosition, this.rangeStart);
        }
        return new BlockState(true, startPosition, Math.min(endPosition, this.rangeEnd));
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long startPosition = this.currentPosition;
        BlockState positionState = this.blockState(n);
        this.currentPosition = positionState.insideRange() ? (this.currentPosition += this.delegate.skip(n)) : positionState.endPosition();
        return this.currentPosition - startPosition;
    }

    @Override
    public int read() throws IOException {
        if (this.currentPosition >= this.totalLength) {
            return -1;
        }
        BlockState positionState = this.blockState(1L);
        try {
            if (positionState.insideRange()) {
                int n = this.delegate.read();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            ++this.currentPosition;
        }
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        Objects.checkFromIndexSize(off, len, buffer.length);
        if (this.currentPosition >= this.totalLength) {
            return -1;
        }
        BlockState positionState = this.blockState(len);
        if (positionState.insideRange()) {
            int readBytes = this.delegate.read(buffer, off, positionState.intLength());
            this.currentPosition += (long)readBytes;
            return readBytes;
        }
        Arrays.fill(buffer, off, off + positionState.intLength(), (byte)0);
        this.currentPosition = positionState.endPosition();
        return positionState.intLength();
    }

    public String toString() {
        return "PartialContentInputStream[range=%d-%d; delegate=%s]".formatted(this.rangeStart, this.rangeEnd, this.delegate);
    }

    @Override
    public int available() throws IOException {
        BlockState state = this.blockState(Integer.MAX_VALUE);
        if (state.insideRange()) {
            return this.delegate.available();
        }
        return state.intLength();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private record BlockState(boolean insideRange, long startPosition, long endPosition) {
        public long length() {
            return this.endPosition - this.startPosition;
        }

        public int intLength() {
            return (int)Math.min(this.length(), Integer.MAX_VALUE);
        }
    }
}

