/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.s3.io;

import internal.org.springframework.content.s3.io.SimpleStorageNameUtils;
import internal.org.springframework.content.s3.io.SimpleStorageResource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import software.amazon.awssdk.services.s3.S3Client;

public class SimpleStorageProtocolResolver
implements ProtocolResolver,
InitializingBean {
    private final S3Client amazonS3;
    private TaskExecutor taskExecutor;

    public SimpleStorageProtocolResolver(S3Client amazonS3) {
        this.amazonS3 = amazonS3;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() {
        if (this.taskExecutor == null) {
            this.taskExecutor = new SyncTaskExecutor();
        }
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (SimpleStorageNameUtils.isSimpleStorageResource(location)) {
            return new SimpleStorageResource(this.amazonS3, SimpleStorageNameUtils.getBucketNameFromLocation(location), SimpleStorageNameUtils.getObjectNameFromLocation(location), this.taskExecutor, SimpleStorageNameUtils.getVersionIdFromLocation(location));
        }
        return null;
    }

    public S3Client getAmazonS3() {
        return this.amazonS3;
    }
}

