/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.versions.jpa;

import internal.org.springframework.versions.LockingService;
import java.security.Principal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;

@Service
public class JpaLockingServiceImpl
implements LockingService {
    private static Log logger = LogFactory.getLog(JpaLockingServiceImpl.class);
    private JdbcTemplate template;

    @Autowired
    public JpaLockingServiceImpl(JdbcTemplate template) {
        this.template = template;
    }

    public boolean lock(Object entityId, Principal principal) {
        if (principal == null) {
            throw new SecurityException("no principal");
        }
        String sql = "SELECT count(lock_owner) from locks where entity_id = ?  and lock_owner = ?";
        Integer rc = (Integer)this.template.queryForObject(sql, (Object[])new String[]{entityId.toString(), principal.getName()}, Integer.class);
        if (rc == 1) {
            return true;
        }
        try {
            sql = "INSERT INTO locks (entity_id, lock_owner) VALUES (?,?)";
            rc = this.template.update(sql, new Object[]{entityId.toString(), principal.getName()});
            return rc == 1;
        }
        catch (DuplicateKeyException e) {
            return false;
        }
    }

    public boolean unlock(Object entityId, Principal principal) {
        if (principal == null) {
            throw new SecurityException("no principal");
        }
        String sql = "DELETE from locks where entity_id = ? and lock_owner = ?";
        int rc = this.template.update(sql, new Object[]{entityId.toString(), principal.getName()});
        return rc == 1;
    }

    public Principal lockOwner(Object entityId) {
        String sql = "SELECT lock_owner from locks where entity_id = '" + entityId + "'";
        List lockOwners = this.template.query(sql, new RowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        });
        if (lockOwners.isEmpty()) {
            return null;
        }
        if (lockOwners.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1);
        }
        final String name = (String)lockOwners.get(0);
        return new Principal(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean implies(Subject subject) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isLockOwner(Object entityId, Principal principal) {
        if (principal == null) {
            throw new SecurityException("no principal");
        }
        String sql = "SELECT entity_id from locks where entity_id = ? and lock_owner = ?";
        SqlRowSet rs = this.template.queryForRowSet(sql, new Object[]{entityId.toString(), principal.getName()});
        return rs.next();
    }
}

