/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.api.controller;

import com.alon.spring.crud.api.controller.CrudController;
import com.alon.spring.crud.api.controller.cache.DeepETagResolver;
import com.alon.spring.crud.api.controller.cache.ETagPolicy;
import com.alon.spring.crud.api.controller.input.Options;
import com.alon.spring.crud.api.controller.input.SearchInput;
import com.alon.spring.crud.api.controller.input.mapper.InputMapper;
import com.alon.spring.crud.core.properties.Properties;
import com.alon.spring.crud.domain.model.BaseEntity;
import com.alon.spring.crud.domain.service.CrudService;
import com.alon.spring.crud.domain.service.exception.ReadException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.context.request.ServletWebRequest;

public abstract class CachedCrudController<MANAGED_ENTITY_ID_TYPE extends Serializable, MANAGED_ENTITY_TYPE extends BaseEntity<MANAGED_ENTITY_ID_TYPE>, CREATE_INPUT_TYPE, UPDATE_INPUT_TYPE, SEARCH_INPUT_TYPE extends SearchInput, SERVICE_TYPE extends CrudService<MANAGED_ENTITY_ID_TYPE, MANAGED_ENTITY_TYPE, ?>>
extends CrudController<MANAGED_ENTITY_ID_TYPE, MANAGED_ENTITY_TYPE, CREATE_INPUT_TYPE, UPDATE_INPUT_TYPE, SEARCH_INPUT_TYPE, SERVICE_TYPE> {
    private final ETagPolicy eTagPolicy;
    @Autowired
    private DeepETagResolver deepETagResolver;

    protected CachedCrudController(SERVICE_TYPE service) {
        super(service, false);
        this.eTagPolicy = ETagPolicy.DISABLED;
    }

    protected CachedCrudController(SERVICE_TYPE service, ETagPolicy eTagPolicy) {
        super(service, CachedCrudController.disableContentCachingInCrudController(eTagPolicy));
        this.eTagPolicy = eTagPolicy;
    }

    protected CachedCrudController(SERVICE_TYPE service, ETagPolicy eTagPolicy, DeepETagResolver deepETagResolver) {
        super(service, CachedCrudController.disableContentCachingInCrudController(eTagPolicy));
        this.eTagPolicy = eTagPolicy;
        this.deepETagResolver = deepETagResolver;
    }

    protected CachedCrudController(SERVICE_TYPE service, ETagPolicy eTagPolicy, DeepETagResolver deepETagResolver, InputMapper<CREATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> createInputMapper, InputMapper<UPDATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> updateInputMapper) {
        super(service, createInputMapper, updateInputMapper, false);
        this.eTagPolicy = eTagPolicy;
        this.deepETagResolver = deepETagResolver;
    }

    private static boolean disableContentCachingInCrudController(ETagPolicy eTagPolicy) {
        return !eTagPolicy.equals((Object)ETagPolicy.SHALLOW);
    }

    @Override
    @GetMapping(value={"${com.alon.spring.crud.path.search:}"})
    public ResponseEntity search(SEARCH_INPUT_TYPE filter, Pageable pageable, Options options, ServletWebRequest request) {
        String eTag;
        ResponseEntity response = this.eTagPolicy.equals((Object)ETagPolicy.DISABLED) || this.eTagPolicy.equals((Object)ETagPolicy.SHALLOW) ? super.search(filter, pageable, options, request) : (request.checkNotModified(eTag = this.deepETagResolver.generateCollectionResourceETag(this.managedEntityClass, (SearchInput)filter)) ? ((ResponseEntity.BodyBuilder)this.buildResponseEntity(HttpStatus.NOT_MODIFIED).header("ETag", new String[]{eTag})).build() : super.search(filter, pageable, options, request));
        return response;
    }

    @Override
    @GetMapping(value={"${com.alon.spring.crud.path.read:/{id}}"})
    public ResponseEntity read(@PathVariable MANAGED_ENTITY_ID_TYPE id, Options options, ServletWebRequest request) throws ReadException {
        String eTag;
        ResponseEntity response = this.eTagPolicy.equals((Object)ETagPolicy.DISABLED) || this.eTagPolicy.equals((Object)ETagPolicy.SHALLOW) ? super.read(id, options, request) : (request.checkNotModified(eTag = this.deepETagResolver.generateSingleResourceETag(this.managedEntityClass, id)) ? ((ResponseEntity.BodyBuilder)this.buildResponseEntity(HttpStatus.NOT_MODIFIED).header("ETag", new String[]{eTag})).build() : super.read(id, options, request));
        return response;
    }

    @Override
    public ResponseEntity.BodyBuilder buildResponseEntity(HttpStatus status) {
        return (ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).cacheControl(this.buildCacheControl());
    }

    private CacheControl buildCacheControl() {
        Properties.CacheControlProperties cacheControlProperties = this.properties.cacheControl;
        CacheControl cacheControl = cacheControlProperties.noCache ? CacheControl.noCache() : (cacheControlProperties.noStore ? CacheControl.noStore() : CacheControl.maxAge((long)cacheControlProperties.maxAge, (TimeUnit)TimeUnit.SECONDS));
        if (cacheControlProperties.cachePublic) {
            cacheControl.cachePublic();
        } else if (cacheControlProperties.cachePrivate) {
            cacheControl.cachePrivate();
        }
        return cacheControl;
    }
}

