/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.api.controller;

import com.alon.spring.crud.api.controller.input.Options;
import com.alon.spring.crud.api.controller.input.SearchInput;
import com.alon.spring.crud.api.controller.input.mapper.InputMapper;
import com.alon.spring.crud.api.controller.input.mapper.ModelMapperInputMapper;
import com.alon.spring.crud.api.controller.output.OutputPage;
import com.alon.spring.crud.api.projection.ProjectionRepresentation;
import com.alon.spring.crud.api.projection.ProjectionService;
import com.alon.spring.crud.core.properties.Properties;
import com.alon.spring.crud.domain.model.BaseEntity;
import com.alon.spring.crud.domain.service.CrudService;
import com.alon.spring.crud.domain.service.SearchCriteria;
import com.alon.spring.crud.domain.service.exception.CreateException;
import com.alon.spring.crud.domain.service.exception.DeleteException;
import com.alon.spring.crud.domain.service.exception.ProjectionException;
import com.alon.spring.crud.domain.service.exception.ReadException;
import com.alon.spring.crud.domain.service.exception.UpdateException;
import com.alon.spring.specification.ExpressionSpecification;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.server.ResponseStatusException;

public abstract class CrudController<MANAGED_ENTITY_ID_TYPE extends Serializable, MANAGED_ENTITY_TYPE extends BaseEntity<MANAGED_ENTITY_ID_TYPE>, CREATE_INPUT_TYPE, UPDATE_INPUT_TYPE, SEARCH_INPUT_TYPE extends SearchInput, SERVICE_TYPE extends CrudService<MANAGED_ENTITY_ID_TYPE, MANAGED_ENTITY_TYPE, ?>> {
    protected final SERVICE_TYPE service;
    @Autowired
    protected ProjectionService projectionService;
    @Autowired
    protected Properties properties;
    protected InputMapper<CREATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> createInputMapper;
    protected InputMapper<UPDATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> updateInputMapper;
    protected final boolean disableContentCaching;
    protected Class<MANAGED_ENTITY_TYPE> managedEntityClass = this.extractManagedEntityType();

    public CrudController(SERVICE_TYPE service) {
        this.service = service;
        this.createInputMapper = new ModelMapperInputMapper<CREATE_INPUT_TYPE, MANAGED_ENTITY_TYPE>(this.managedEntityClass);
        this.updateInputMapper = new ModelMapperInputMapper<UPDATE_INPUT_TYPE, MANAGED_ENTITY_TYPE>(this.managedEntityClass);
        this.disableContentCaching = true;
    }

    public CrudController(SERVICE_TYPE service, boolean disableContentCaching) {
        this.service = service;
        this.createInputMapper = new ModelMapperInputMapper<CREATE_INPUT_TYPE, MANAGED_ENTITY_TYPE>(this.managedEntityClass);
        this.updateInputMapper = new ModelMapperInputMapper<UPDATE_INPUT_TYPE, MANAGED_ENTITY_TYPE>(this.managedEntityClass);
        this.disableContentCaching = disableContentCaching;
    }

    protected CrudController(SERVICE_TYPE service, InputMapper<CREATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> createInputMapper, InputMapper<UPDATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> updateInputMapper) {
        this.service = service;
        this.createInputMapper = createInputMapper;
        this.updateInputMapper = updateInputMapper;
        this.disableContentCaching = true;
    }

    protected CrudController(SERVICE_TYPE service, InputMapper<CREATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> createInputMapper, InputMapper<UPDATE_INPUT_TYPE, MANAGED_ENTITY_TYPE> updateInputMapper, boolean disableContentCaching) {
        this.service = service;
        this.createInputMapper = createInputMapper;
        this.updateInputMapper = updateInputMapper;
        this.disableContentCaching = disableContentCaching;
    }

    @GetMapping(value={"${com.alon.spring.crud.path.search:}"})
    public ResponseEntity search(SEARCH_INPUT_TYPE filter, Pageable pageable, Options options, ServletWebRequest request) {
        OutputPage response;
        if (this.disableContentCaching) {
            ShallowEtagHeaderFilter.disableContentCaching((ServletRequest)request.getRequest());
        }
        this.normalizeCollectionOptions(options);
        SearchCriteria criteria = SearchCriteria.of().filter(this.resolveFilter(filter)).pageable(pageable).expand(options.getExpand()).build();
        Page page = this.service.search(criteria);
        try {
            response = this.projectionService.project(options.getProjection(), page);
        }
        catch (ProjectionException e) {
            if (this.projectDefaultOnError(options.getProjection())) {
                response = this.projectionService.project(this.getCollectionDefaultProjection(), page);
            }
            throw e;
        }
        return this.buildResponseEntity(HttpStatus.OK).body(response);
    }

    @GetMapping(value={"${com.alon.spring.crud.path.read:/{id}}"})
    public ResponseEntity read(@PathVariable MANAGED_ENTITY_ID_TYPE id, Options options, ServletWebRequest request) throws ReadException {
        Object response;
        if (this.disableContentCaching) {
            ShallowEtagHeaderFilter.disableContentCaching((ServletRequest)request.getRequest());
        }
        this.normalizeSingleOptions(options);
        Object entity = this.service.read(id, options.getExpand());
        if (entity == null) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
        try {
            response = this.projectionService.project(options.getProjection(), entity);
        }
        catch (ProjectionException e) {
            if (this.projectDefaultOnError(options.getProjection())) {
                return (ResponseEntity)this.projectionService.project(this.getSingleDefaultProjection(), entity);
            }
            throw e;
        }
        return this.buildResponseEntity(HttpStatus.OK).body(response);
    }

    @PostMapping(value={"${com.alon.spring.crud.path.create:}"})
    protected ResponseEntity create(@RequestBody @Valid CREATE_INPUT_TYPE input, @RequestParam(required=false) String projection) throws CreateException {
        Object response;
        BaseEntity entity = (BaseEntity)this.createInputMapper.map(input);
        entity = this.service.create((BaseEntity)entity);
        projection = this.normalizeSingleProjection(projection);
        try {
            response = this.projectionService.project(projection, entity);
        }
        catch (ProjectionException e) {
            if (this.projectDefaultOnError(projection)) {
                response = this.projectionService.project(this.getSingleDefaultProjection(), entity);
            }
            throw e;
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(response);
    }

    @PutMapping(value={"${com.alon.spring.crud.path.update:/{id}}"})
    public ResponseEntity update(@PathVariable MANAGED_ENTITY_ID_TYPE id, @RequestBody @Valid UPDATE_INPUT_TYPE input, @RequestParam(required=false) String projection) throws UpdateException {
        Object response;
        BaseEntity entity = (BaseEntity)this.updateInputMapper.map(input);
        entity.setId(id);
        entity = this.service.update((BaseEntity)entity);
        projection = this.normalizeSingleProjection(projection);
        try {
            response = this.projectionService.project(projection, entity);
        }
        catch (ProjectionException e) {
            if (this.projectDefaultOnError(projection)) {
                response = this.projectionService.project(this.getSingleDefaultProjection(), entity);
            }
            throw e;
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(response);
    }

    @DeleteMapping(value={"${com.alon.spring.crud.path.delete:/{id}}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable MANAGED_ENTITY_ID_TYPE id) throws DeleteException {
        this.service.delete(id);
    }

    @GetMapping(value={"/projections"})
    public List<ProjectionRepresentation> getRepresentations() {
        return this.projectionService.getEntityRepresentations(this.extractManagedEntityType());
    }

    public ResponseEntity.BodyBuilder buildResponseEntity(HttpStatus status) {
        return ResponseEntity.status((HttpStatus)status);
    }

    protected String getSingleDefaultProjection() {
        return "no-operation-projection";
    }

    protected String getCollectionDefaultProjection() {
        return "no-operation-projection";
    }

    protected void normalizeSingleOptions(Options options) {
        options.setProjection(this.normalizeSingleProjection(options.getProjection()));
        options.setExpand(this.normalizeExpand(options.getProjection(), options.getExpand()));
    }

    protected void normalizeCollectionOptions(Options options) {
        options.setProjection(this.normalizeCollectionProjection(options.getProjection()));
        options.setExpand(this.normalizeExpand(options.getProjection(), options.getExpand()));
    }

    protected String normalizeSingleProjection(String projectionName) {
        if (projectionName != null && this.projectionService.projectionExists(projectionName)) {
            return projectionName;
        }
        return this.getSingleDefaultProjection();
    }

    protected String normalizeCollectionProjection(String projectionName) {
        if (projectionName != null && this.projectionService.projectionExists(projectionName)) {
            return projectionName;
        }
        return this.getCollectionDefaultProjection();
    }

    protected List<String> normalizeExpand(String projectionName, List<String> receivedExpand) {
        if (projectionName.equals("no-operation-projection")) {
            return receivedExpand;
        }
        return this.projectionService.getRequiredExpand(projectionName);
    }

    protected Specification resolveFilter(SEARCH_INPUT_TYPE filter) {
        if (((SearchInput)filter).expressionPresent()) {
            if (!this.properties.search.enableExpressionFilter) {
                throw new ResponseStatusException(HttpStatus.LOCKED, "The filter by expression feature is not enabled.");
            }
            return ExpressionSpecification.of((String)((SearchInput)filter).getExpression());
        }
        return ((SearchInput)filter).toSpecification();
    }

    private final <T extends BaseEntity<MANAGED_ENTITY_ID_TYPE>> Class<T> extractManagedEntityType() {
        ParameterizedType classType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)classType.getActualTypeArguments()[1];
    }

    private boolean projectDefaultOnError(String projection) {
        return this.properties.projection.useDefaultIfError && !projection.equals(this.getCollectionDefaultProjection());
    }
}

