/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.api.controller.cache;

import com.alon.spring.crud.api.controller.cache.CollectionResourceDeepETagGenerator;
import com.alon.spring.crud.api.controller.cache.DeepETagGenerator;
import com.alon.spring.crud.api.controller.cache.SingleResourceDeepETagGenerator;
import com.alon.spring.crud.api.controller.input.SearchInput;
import com.alon.spring.crud.domain.model.BaseEntity;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class DeepETagResolver {
    private EntityManager entityManager;
    private DeepETagGenerator singleResourceDeepETagGenerator;
    private DeepETagGenerator collectionResourceETagGenerator;

    public DeepETagResolver(EntityManager entityManager, DeepETagGenerator singleResourceDeepETagGenerator, DeepETagGenerator collectionResourceETagGenerator) {
        this.entityManager = entityManager;
        this.singleResourceDeepETagGenerator = singleResourceDeepETagGenerator;
        this.collectionResourceETagGenerator = collectionResourceETagGenerator;
    }

    @Autowired
    public DeepETagResolver(EntityManager entityManager, SingleResourceDeepETagGenerator singleResourceDeepETagGenerator, CollectionResourceDeepETagGenerator collectionResourceETagGenerator) {
        this.entityManager = entityManager;
        this.singleResourceDeepETagGenerator = singleResourceDeepETagGenerator;
        this.collectionResourceETagGenerator = collectionResourceETagGenerator;
    }

    public <ID> String generateSingleResourceETag(Class<? extends BaseEntity<?>> entityType, final ID id) {
        SearchInput search = new SearchInput(){

            @Override
            public Specification toSpecification() {
                return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get("id"), id);
            }
        };
        return this.singleResourceDeepETagGenerator.generate(entityType, this.entityManager, search);
    }

    public String generateCollectionResourceETag(Class<? extends BaseEntity<?>> entityType, SearchInput search) {
        return this.collectionResourceETagGenerator.generate(entityType, this.entityManager, search);
    }
}

