/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.api.controller.cache;

import com.alon.spring.crud.api.controller.cache.SingleResourceDeepETagGenerator;
import com.alon.spring.crud.api.controller.input.SearchInput;
import com.alon.spring.crud.domain.model.BaseEntity;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class SingleResourceDeepETagGeneratorImpl
implements SingleResourceDeepETagGenerator {
    @Override
    public String generate(Class<? extends BaseEntity<?>> entityType, EntityManager entityManager, SearchInput search) {
        Object lastUpdate;
        Predicate predicate;
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery();
        Root from = query.from(entityType);
        query.multiselect(new Selection[]{from.get("updateTimestamp")});
        Specification specification = search.toSpecification();
        if (specification != null && (predicate = specification.toPredicate(from, query, builder)) != null) {
            query.where((Expression)predicate);
        }
        try {
            lastUpdate = entityManager.createQuery(query).getSingleResult();
        }
        catch (NoResultException ex) {
            lastUpdate = null;
        }
        if (lastUpdate == null) {
            lastUpdate = "NOT MODIFIED";
        }
        return String.valueOf(lastUpdate.hashCode());
    }
}

