/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.api.exceptionhandler;

import com.alon.spring.crud.api.exception.BeanValidationException;
import com.alon.spring.crud.api.exceptionhandler.ExceptionUtils;
import com.alon.spring.crud.api.exceptionhandler.Problem;
import com.alon.spring.crud.api.exceptionhandler.ProblemType;
import com.alon.spring.crud.domain.service.exception.CrudException;
import com.alon.spring.crud.domain.service.exception.DataIntegrityException;
import com.alon.spring.crud.domain.service.exception.NotFoundException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.PropertyBindingException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.TypeMismatchException;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ApiExceptionHandler
extends ResponseEntityExceptionHandler {
    private MessageSource messageSource;

    public ApiExceptionHandler(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity handleUncaught(Exception ex, WebRequest request) {
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        String detail = "An internal server problem has occurred. If the problem persists, contact your administrator.";
        Problem problem = this.createProblemBuilder(status, ProblemType.INTERNAL_ERROR, detail).build();
        return this.handleExceptionInternal(ex, problem, new HttpHeaders(), status, request);
    }

    @ExceptionHandler(value={CrudException.class})
    public ResponseEntity handleCrudException(CrudException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        Throwable cause = ExceptionUtils.getRootCause(ex);
        if (cause instanceof PropertyReferenceException) {
            return this.handlePropertyReferenceException((PropertyReferenceException)cause, headers, request);
        }
        return this.handleUncaught(ex, request);
    }

    @ExceptionHandler(value={PropertyReferenceException.class})
    public ResponseEntity handlePropertyReferenceException(PropertyReferenceException ex, HttpHeaders headers, WebRequest request) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        String detail = String.format("Invalid property name %s", ex.getPropertyName());
        Problem problem = this.createProblemBuilder(status, ProblemType.UNRECOGNIZED_MESSAGE, detail).build();
        return this.handleExceptionInternal((Exception)ex, problem, headers, status, request);
    }

    protected ResponseEntity handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
        if (rootCause instanceof InvalidFormatException) {
            return this.handleInvalidFormatException((InvalidFormatException)rootCause, headers, status, request);
        }
        if (rootCause instanceof PropertyBindingException) {
            return this.handlePropertyBindingException((PropertyBindingException)rootCause, headers, status, request);
        }
        String detail = "Invalid request body.";
        Problem problem = this.createProblemBuilder(status, ProblemType.UNRECOGNIZED_MESSAGE, detail).build();
        return this.handleExceptionInternal((Exception)ex, problem, headers, status, request);
    }

    @ExceptionHandler(value={InvalidFormatException.class})
    public ResponseEntity handleInvalidFormatException(InvalidFormatException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String detail = "'%' is not a valid value for the '%s' property. The required type is %s.";
        String field = this.joinPath(ex.getPath());
        detail = String.format(detail, ex.getValue(), field, ex.getTargetType().getSimpleName());
        Problem problem = this.createProblemBuilder(status, ProblemType.UNRECOGNIZED_MESSAGE, detail).build();
        return this.handleExceptionInternal((Exception)ex, problem, headers, status, request);
    }

    @ExceptionHandler(value={PropertyBindingException.class})
    public ResponseEntity handlePropertyBindingException(PropertyBindingException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String field = this.joinPath(ex.getPath());
        String detail = String.format("Invalid property '%s'.", field);
        Problem problem = this.createProblemBuilder(status, ProblemType.UNRECOGNIZED_MESSAGE, detail).build();
        return this.handleExceptionInternal((Exception)ex, problem, headers, status, request);
    }

    protected ResponseEntity handleTypeMismatch(TypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (ex instanceof MethodArgumentTypeMismatchException) {
            return this.handleMethodArgumentTypeMismatchException((MethodArgumentTypeMismatchException)ex, headers, status, request);
        }
        return super.handleTypeMismatch(ex, headers, status, request);
    }

    public ResponseEntity handleMethodArgumentTypeMismatchException(MethodArgumentTypeMismatchException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String detail = "'%s' is an invalid value for the '%s' URL parameter. Required type is '%s'.";
        detail = String.format(detail, ex.getValue(), ex.getName(), ex.getRequiredType().getSimpleName());
        Problem problem = this.createProblemBuilder(status, ProblemType.INVALID_PARAMETER, detail).build();
        return this.handleExceptionInternal((Exception)ex, problem, headers, status, request);
    }

    protected ResponseEntity handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return this.handleValidationInternal((Exception)ex, headers, status, request, ex.getBindingResult());
    }

    public ResponseEntity handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return this.handleValidationInternal((Exception)ex, headers, status, request, ex.getBindingResult());
    }

    private ResponseEntity handleValidationInternal(Exception ex, HttpHeaders headers, HttpStatus status, WebRequest request, BindingResult bindingResult) {
        String detail = "Invalid fields.";
        List<Problem.Violation> problemFields = this.createProblemFields(bindingResult);
        Problem problem = this.createProblemBuilder(status, ProblemType.INVALID_DATA, detail).violations(problemFields).build();
        return this.handleExceptionInternal(ex, problem, headers, status, request);
    }

    protected ResponseEntity handleNoHandlerFoundException(NoHandlerFoundException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        String detail = String.format("Resource not found: '%s'", ex.getRequestURL());
        Problem problem = this.createProblemBuilder(status, ProblemType.NOT_FOUND, detail).build();
        return super.handleExceptionInternal((Exception)ex, (Object)problem, headers, status, request);
    }

    @ExceptionHandler(value={BeanValidationException.class})
    public ResponseEntity handleBeanValidation(BeanValidationException ex, WebRequest request) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        String detail = "Invalid fields present.";
        List<Problem.Violation> problemFields = this.createProblemFields(ex.getBindingResult());
        Problem problem = this.createProblemBuilder(status, ProblemType.INVALID_DATA, detail).violations(problemFields).build();
        return this.handleExceptionInternal(ex, problem, new HttpHeaders(), status, request);
    }

    @ExceptionHandler(value={NotFoundException.class})
    public ResponseEntity handleNotFoundException(NotFoundException ex, WebRequest request) {
        HttpStatus status = HttpStatus.NOT_FOUND;
        Problem problem = this.createProblemBuilder(status, ProblemType.NOT_FOUND, ex.getMessage()).build();
        return this.handleExceptionInternal(ex, problem, new HttpHeaders(), status, request);
    }

    @ExceptionHandler(value={DataIntegrityException.class})
    public ResponseEntity handleDataIntegrityException(DataIntegrityException ex, WebRequest request) {
        HttpStatus status = HttpStatus.NOT_FOUND;
        Problem problem = this.createProblemBuilder(status, ProblemType.INTEGRITY_VIOLATION, ex.getMessage()).build();
        return this.handleExceptionInternal(ex, problem, new HttpHeaders(), status, request);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity handleIllegalArgumentException(IllegalArgumentException ex, WebRequest request) {
        HttpStatus status = HttpStatus.BAD_REQUEST;
        String detail = "There is a problem with the data sent.";
        Problem.Violation violation = Problem.Violation.of().context("Original error message").message(ex.getMessage()).build();
        Problem problem = this.createProblemBuilder(status, ProblemType.INVALID_DATA, detail).violations(List.of(violation)).build();
        return this.handleExceptionInternal(ex, problem, new HttpHeaders(), status, request);
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public ResponseEntity handleResponseStatusException(ResponseStatusException ex, WebRequest request) {
        HttpStatus status = ex.getStatus();
        String detail = ex.getReason();
        Problem problem = this.createProblemBuilder(status, ProblemType.LOCKED, detail).build();
        return this.handleExceptionInternal((Exception)ex, problem, new HttpHeaders(), status, request);
    }

    protected ResponseEntity handleExceptionInternal(Exception ex, Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (body == null) {
            body = Problem.of().status(status.value()).title(status.getReasonPhrase()).build();
        } else if (body instanceof String) {
            body = Problem.of().status(status.value()).title((String)body).build();
        }
        return super.handleExceptionInternal(ex, body, headers, status, request);
    }

    private List<Problem.Violation> createProblemFields(BindingResult bindingResult) {
        return bindingResult.getAllErrors().stream().map(error -> {
            String message = this.messageSource.getMessage((MessageSourceResolvable)error, LocaleContextHolder.getLocale());
            String name = error.getObjectName();
            if (error instanceof FieldError) {
                name = ((FieldError)error).getField();
            }
            return Problem.Violation.of().context(name).message(message).build();
        }).collect(Collectors.toList());
    }

    private Problem.ProblemBuilder createProblemBuilder(HttpStatus status, ProblemType type, String detail) {
        return Problem.of().timestamp(OffsetDateTime.now()).status(status.value()).type(type.getUri()).title(type.getTitle()).detail(detail);
    }

    private String joinPath(List<JsonMappingException.Reference> path) {
        return path.stream().map(JsonMappingException.Reference::getFieldName).collect(Collectors.joining("."));
    }
}

