/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.api.exceptionhandler;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.OffsetDateTime;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Problem {
    private Integer status;
    private String type;
    private String title;
    private String detail;
    private OffsetDateTime timestamp;
    private List<Violation> violations;

    public Integer getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDetail() {
        return this.detail;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public List<Violation> getViolations() {
        return this.violations;
    }

    public static ProblemBuilder of() {
        return new ProblemBuilder();
    }

    public static class ProblemBuilder {
        private final Problem problem = new Problem();

        private ProblemBuilder() {
        }

        public ProblemBuilder status(Integer status) {
            this.problem.status = status;
            return this;
        }

        public ProblemBuilder type(String type) {
            this.problem.type = type;
            return this;
        }

        public ProblemBuilder title(String title) {
            this.problem.title = title;
            return this;
        }

        public ProblemBuilder detail(String detail) {
            this.problem.detail = detail;
            return this;
        }

        public ProblemBuilder timestamp(OffsetDateTime timestamp) {
            this.problem.timestamp = timestamp;
            return this;
        }

        public ProblemBuilder violations(List<Violation> violations) {
            this.problem.violations = violations;
            return this;
        }

        public Problem build() {
            return this.problem;
        }
    }

    public static class Violation {
        private String context;
        private String message;

        public String getContext() {
            return this.context;
        }

        public String getMessage() {
            return this.message;
        }

        public static ViolationBuilder of() {
            return new ViolationBuilder();
        }

        public static class ViolationBuilder {
            private final Violation violation = new Violation();

            private ViolationBuilder() {
            }

            public ViolationBuilder context(String context) {
                this.violation.context = context;
                return this;
            }

            public ViolationBuilder message(String message) {
                this.violation.message = message;
                return this;
            }

            public Violation build() {
                return this.violation;
            }
        }
    }
}

