/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.api.projection;

import com.alon.spring.crud.api.controller.output.OutputPage;
import com.alon.spring.crud.api.projection.ProjectionRepresentation;
import com.alon.spring.crud.api.projection.Projector;
import com.alon.spring.crud.api.projection.RepresentationService;
import com.alon.spring.crud.domain.model.BaseEntity;
import com.alon.spring.crud.domain.service.exception.ProjectionException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class ProjectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectionService.class);
    public static final String NOP_PROJECTION = "no-operation-projection";
    private ApplicationContext applicationContext;
    private RepresentationService representationService;
    private final Map<String, Projector> projections;
    private final Map<Class, List<ProjectionRepresentation>> representationsCache = new HashMap<Class, List<ProjectionRepresentation>>();

    public ProjectionService(ApplicationContext applicationContext, RepresentationService representationService) {
        this.applicationContext = applicationContext;
        this.representationService = representationService;
        this.projections = this.applicationContext.getBeansOfType(Projector.class);
    }

    public <I extends BaseEntity, O> O project(String projectionName, I input) {
        if (projectionName.equals(NOP_PROJECTION)) {
            return (O)input;
        }
        try {
            Projector projector = this.getProjector(projectionName);
            return projector.project(input);
        }
        catch (ProjectionException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Error projecting entity %s with projector '%s'", input.getClass().getSimpleName(), projectionName);
            LOGGER.error(message, (Throwable)e);
            throw new ProjectionException(message, e);
        }
    }

    public <I extends BaseEntity, O> OutputPage<O> project(String projectionName, Page<I> input) {
        try {
            List content = input.getContent();
            if (projectionName.equals(NOP_PROJECTION)) {
                content = input.getContent();
            } else {
                Projector projector = this.getProjector(projectionName);
                content = input.getContent().stream().map(projector::project).collect(Collectors.toList());
            }
            return OutputPage.of().page(input.getNumber()).pageSize(input.getNumberOfElements()).totalPages(input.getTotalPages()).totalSize(Long.valueOf(input.getTotalElements()).intValue()).content(content).build();
        }
        catch (ProjectionException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Error projecting page with projector '%s'", projectionName);
            LOGGER.error(message, (Throwable)e);
            throw new ProjectionException(message, e);
        }
    }

    public List<String> getRequiredExpand(String projectionName) {
        Projector projector = this.getProjector(projectionName);
        return projector.requiredExpand();
    }

    public boolean projectionExists(String projectionName) {
        return this.projections.containsKey(projectionName);
    }

    public List<ProjectionRepresentation> getEntityRepresentations(Class<? extends BaseEntity> clazz) {
        if (this.representationsCache.containsKey(clazz)) {
            return this.representationsCache.get(clazz);
        }
        Map<String, Projector> projections = this.getEntityProjections(clazz);
        List<ProjectionRepresentation> representations = projections.entrySet().stream().map(this::getProjectionRepresentation).collect(Collectors.toList());
        this.representationsCache.put(clazz, representations);
        return representations;
    }

    private Projector getProjector(String projectionName) {
        Projector projector = this.projections.get(projectionName);
        if (projector == null) {
            throw new ProjectionException(String.format("Projection '%s' not found", projectionName));
        }
        return projector;
    }

    private Map<String, Projector> getEntityProjections(Class<? extends BaseEntity> entityType) {
        return this.projections.keySet().stream().filter(key -> this.projectorInputTypeIsTheExpected((String)key, entityType)).collect(Collectors.toMap(projectionName -> projectionName, this.projections::get));
    }

    private ProjectionRepresentation getProjectionRepresentation(Map.Entry<String, Projector> entry) {
        Class projectionOutput = this.getProjectorOutputType(entry.getValue());
        Map<String, Object> representation = this.representationService.getRepresentationOf(projectionOutput);
        return new ProjectionRepresentation(entry.getKey(), representation);
    }

    private boolean projectorInputTypeIsTheExpected(String projectionName, Class<? extends BaseEntity> expectedInputType) {
        Projector projector = this.projections.get(projectionName);
        Type inputType = this.getProjectorInputType(projector);
        if (!(inputType instanceof Class)) {
            return false;
        }
        return ((Class)inputType).isAssignableFrom(expectedInputType);
    }

    private Type getProjectorInputType(Projector projector) {
        ParameterizedType projectorType = this.getProjectorParameterizedType(projector);
        return projectorType.getActualTypeArguments()[0];
    }

    private Class getProjectorOutputType(Projector projector) {
        ParameterizedType projectorType = this.getProjectorParameterizedType(projector);
        return (Class)projectorType.getActualTypeArguments()[1];
    }

    private ParameterizedType getProjectorParameterizedType(Projector projector) {
        Optional<Type> projectorTypeOpt = List.of(projector.getClass().getGenericInterfaces()).stream().filter(type -> type instanceof ParameterizedType).filter(type -> ((ParameterizedType)type).getRawType().equals(Projector.class)).findFirst();
        return (ParameterizedType)projectorTypeOpt.get();
    }
}

