/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.core.properties;

import com.alon.spring.crud.core.properties.CacheControlInvalidConfigurationException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="com.alon.spring.crud")
public class Properties {
    public CacheControlProperties cacheControl = new CacheControlProperties();
    public SearchProperties search = new SearchProperties();
    public ProjectionProperties projection = new ProjectionProperties();

    public CacheControlProperties getCacheControl() {
        return this.cacheControl;
    }

    public void setCacheControl(CacheControlProperties cacheControl) {
        this.cacheControl = cacheControl;
    }

    public SearchProperties getSearch() {
        return this.search;
    }

    public void setSearch(SearchProperties search) {
        this.search = search;
    }

    public ProjectionProperties getProjection() {
        return this.projection;
    }

    public void setProjection(ProjectionProperties projection) {
        this.projection = projection;
    }

    public class ProjectionProperties {
        public boolean useDefaultIfError = true;

        public boolean isUseDefaultIfError() {
            return this.useDefaultIfError;
        }

        public void setUseDefaultIfError(boolean useDefaultIfError) {
            this.useDefaultIfError = useDefaultIfError;
        }
    }

    public class SearchProperties {
        public boolean enableExpressionFilter = false;

        public boolean isEnableExpressionFilter() {
            return this.enableExpressionFilter;
        }

        public void setEnableExpressionFilter(boolean enableExpressionFilter) {
            this.enableExpressionFilter = enableExpressionFilter;
        }
    }

    public class CacheControlProperties {
        public long maxAge = 600L;
        public boolean cachePrivate;
        public boolean cachePublic;
        public boolean noCache;
        public boolean noStore;

        public long getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(long maxAge) {
            this.maxAge = maxAge;
        }

        public boolean isCachePrivate() {
            return this.cachePrivate;
        }

        public void setCachePrivate(boolean cachePrivate) {
            this.validateCacheScope(this.cachePublic, cachePrivate);
            this.validateNoStore(this.noStore);
            this.cachePrivate = cachePrivate;
        }

        public boolean isCachePublic() {
            return this.cachePublic;
        }

        public void setCachePublic(boolean cachePublic) {
            this.validateCacheScope(cachePublic, this.cachePrivate);
            this.validateNoStore(this.noStore);
            this.cachePublic = cachePublic;
        }

        public boolean isNoCache() {
            return this.noCache;
        }

        public void setNoCache(boolean noCache) {
            this.validateNoStore(this.noStore);
            this.noCache = noCache;
        }

        public boolean isNoStore() {
            return this.noStore;
        }

        public void setNoStore(boolean noStore) {
            this.validateNoStore(noStore);
            this.noStore = noStore;
        }

        private void validateCacheScope(boolean cachePublic, boolean cachePrivate) {
            if (cachePublic && cachePrivate) {
                throw new CacheControlInvalidConfigurationException("Only one of the http cache scopes must be activated: public or private");
            }
        }

        private void validateNoStore(boolean noStore) {
            if (noStore) {
                String message = "It is not possible to enable the '%s' directive when the 'noStore' directive is enabled.";
                if (this.cachePublic) {
                    throw new CacheControlInvalidConfigurationException(String.format(message, "public"));
                }
                if (this.cachePrivate) {
                    throw new CacheControlInvalidConfigurationException(String.format(message, "private"));
                }
                if (this.noCache) {
                    throw new CacheControlInvalidConfigurationException(String.format(message, "noCache"));
                }
            }
        }
    }
}

