/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.domain.service;

import com.alon.spring.crud.domain.model.BaseEntity;
import com.alon.spring.crud.domain.service.SearchCriteria;
import com.alon.spring.crud.domain.service.exception.CreateException;
import com.alon.spring.crud.domain.service.exception.DeleteException;
import com.alon.spring.crud.domain.service.exception.NotFoundException;
import com.alon.spring.crud.domain.service.exception.ReadException;
import com.alon.spring.crud.domain.service.exception.UpdateException;
import com.cosium.spring.data.jpa.entity.graph.domain.DynamicEntityGraph;
import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph;
import com.cosium.spring.data.jpa.entity.graph.repository.EntityGraphJpaRepository;
import com.cosium.spring.data.jpa.entity.graph.repository.EntityGraphJpaSpecificationExecutor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public interface CrudService<ENTITY_ID_TYPE extends Serializable, ENTITY_TYPE extends BaseEntity<ENTITY_ID_TYPE>, REPOSITORY extends EntityGraphJpaRepository<ENTITY_TYPE, ENTITY_ID_TYPE> & EntityGraphJpaSpecificationExecutor<ENTITY_TYPE>> {
    public REPOSITORY getRepository();

    @Transactional(propagation=Propagation.SUPPORTS)
    default public Page<ENTITY_TYPE> search(SearchCriteria criteria) {
        try {
            Page searchResult;
            HookHelper.executeHook(this, criteria, HookHelper.LifeCycleHook.BEFORE_SEARCH);
            Pageable pageable = criteria.getPageable();
            switch (criteria.getSearchOption()) {
                case FILTER: {
                    searchResult = ((JpaSpecificationExecutor)this.getRepository()).findAll(criteria.getFilter(), pageable);
                    break;
                }
                case EXPAND: {
                    searchResult = this.getRepository().findAll(pageable, criteria.getExpand());
                    break;
                }
                case FILTER_EXPAND: {
                    searchResult = ((EntityGraphJpaSpecificationExecutor)this.getRepository()).findAll(criteria.getFilter(), pageable, criteria.getExpand());
                    break;
                }
                default: {
                    searchResult = this.getRepository().findAll(pageable);
                }
            }
            HookHelper.executeHook(this, searchResult, HookHelper.LifeCycleHook.AFTER_SEARCH);
            return searchResult;
        }
        catch (Throwable ex) {
            String message = String.format("Error searching entities: %s", ex.getMessage());
            throw new ReadException(message, ex);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    default public ENTITY_TYPE create(@Valid ENTITY_TYPE entity) {
        try {
            entity = (BaseEntity)HookHelper.executeHook(this, entity, HookHelper.LifeCycleHook.BEFORE_CREATE);
            entity = (BaseEntity)this.getRepository().save(entity);
            return (ENTITY_TYPE)((BaseEntity)HookHelper.executeHook(this, entity, HookHelper.LifeCycleHook.AFTER_CREATE));
        }
        catch (Throwable ex) {
            throw new CreateException(ex.getMessage(), ex);
        }
    }

    default public ENTITY_TYPE read(ENTITY_ID_TYPE id) {
        return this.read(id, null);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    default public ENTITY_TYPE read(ENTITY_ID_TYPE id, List<String> expand) {
        try {
            id = (Serializable)HookHelper.executeHook(this, id, HookHelper.LifeCycleHook.BEFORE_READ);
            Optional opt = expand != null && !expand.isEmpty() ? this.getRepository().findById(id, (EntityGraph)new DynamicEntityGraph(expand)) : this.getRepository().findById(id);
            if (opt.isEmpty()) {
                throw new NotFoundException(String.format("ID not found -> %d", id));
            }
            BaseEntity entity = (BaseEntity)opt.get();
            entity = HookHelper.executeHook(this, entity, HookHelper.LifeCycleHook.AFTER_READ);
            return (ENTITY_TYPE)entity;
        }
        catch (NotFoundException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            String message = String.format("Error reading entity: %s", ex.getMessage());
            throw new ReadException(message, ex);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    default public ENTITY_TYPE update(@Valid ENTITY_TYPE entity) {
        if (!this.getRepository().existsById((Object)((Serializable)((BaseEntity)entity).getId()))) {
            throw new NotFoundException("Entity to update not found");
        }
        try {
            entity = (BaseEntity)HookHelper.executeHook(this, entity, HookHelper.LifeCycleHook.BEFORE_UPDATE);
            entity = (BaseEntity)this.getRepository().save(entity);
            return (ENTITY_TYPE)((BaseEntity)HookHelper.executeHook(this, entity, HookHelper.LifeCycleHook.AFTER_UPDATE));
        }
        catch (Throwable ex) {
            throw new UpdateException(ex.getMessage(), ex);
        }
    }

    @Transactional(rollbackFor={Throwable.class})
    default public void delete(ENTITY_ID_TYPE id) {
        if (!this.getRepository().existsById(id)) {
            throw new NotFoundException("Entity to delete not found");
        }
        try {
            HookHelper.executeHook(this, id, HookHelper.LifeCycleHook.BEFORE_DELETE);
            this.getRepository().deleteById(id);
            HookHelper.executeHook(this, id, HookHelper.LifeCycleHook.AFTER_DELETE);
        }
        catch (Throwable ex) {
            throw new DeleteException(ex.getMessage(), ex);
        }
    }

    default public void addBeforeSearchHook(Function<SearchCriteria, SearchCriteria> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.BEFORE_SEARCH).add(function);
    }

    default public void addAfterSearchHook(Function<Page<ENTITY_TYPE>, Page<ENTITY_TYPE>> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.AFTER_SEARCH).add(function);
    }

    default public void addBeforeReadHook(Function<ENTITY_ID_TYPE, ENTITY_ID_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.BEFORE_READ).add(function);
    }

    default public void addAfterReadHook(Function<ENTITY_TYPE, ENTITY_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.AFTER_READ).add(function);
    }

    default public void addBeforeCreateHook(Function<ENTITY_TYPE, ENTITY_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.BEFORE_CREATE).add(function);
    }

    default public void addAfterCreateHook(Function<ENTITY_TYPE, ENTITY_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.AFTER_CREATE).add(function);
    }

    default public void addBeforeUpdateHook(Function<ENTITY_TYPE, ENTITY_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.BEFORE_UPDATE).add(function);
    }

    default public void addAfterUpdateHook(Function<ENTITY_TYPE, ENTITY_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.AFTER_UPDATE).add(function);
    }

    default public void addBeforeDeleteHook(Function<ENTITY_ID_TYPE, ENTITY_ID_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.BEFORE_DELETE).add(function);
    }

    default public void addAfterDeleteHook(Function<ENTITY_ID_TYPE, ENTITY_ID_TYPE> function) {
        HookHelper.getServiceHooks(this).get((Object)HookHelper.LifeCycleHook.AFTER_DELETE).add(function);
    }

    default public void clearHooks(HookHelper.LifeCycleHook ... hookTypes) {
        HookHelper.clearHooks(this, hookTypes);
    }

    public static class HookHelper {
        private static Map<CrudService, Map<LifeCycleHook, List<Function>>> GLOBAL_HOOKS = new HashMap<CrudService, Map<LifeCycleHook, List<Function>>>();

        private static <S extends CrudService, P> P executeHook(S service, P param, LifeCycleHook hookType) throws Throwable {
            List<Function> hooks = HookHelper.getHook(service, hookType);
            param = hooks.stream().reduce(Function.identity(), Function::andThen).apply(param);
            return param;
        }

        private static <S extends CrudService> List<Function> getHook(S service, LifeCycleHook hookType) {
            return HookHelper.getServiceHooks(service).get((Object)hookType);
        }

        private static <T extends CrudService> Map<LifeCycleHook, List<Function>> getServiceHooks(T service) {
            Map<LifeCycleHook, List<Function>> hooks = GLOBAL_HOOKS.get(service);
            if (hooks == null) {
                hooks = HookHelper.initHooks(service);
            }
            return hooks;
        }

        private static <T extends CrudService> Map<LifeCycleHook, List<Function>> initHooks(T service) {
            HashMap<LifeCycleHook, List<Function>> hooks = new HashMap<LifeCycleHook, List<Function>>();
            for (LifeCycleHook hook : LifeCycleHook.values()) {
                hooks.put(hook, new ArrayList());
            }
            GLOBAL_HOOKS.put(service, hooks);
            return hooks;
        }

        private static <T extends CrudService> void clearHooks(T service, LifeCycleHook ... hookTypes) {
            for (LifeCycleHook hook : hookTypes) {
                Map<LifeCycleHook, List<Function>> hooks = GLOBAL_HOOKS.get(service);
                if (hooks == null) continue;
                hooks.get((Object)hook).clear();
            }
        }

        static enum LifeCycleHook {
            BEFORE_SEARCH,
            AFTER_SEARCH,
            BEFORE_READ,
            AFTER_READ,
            BEFORE_CREATE,
            AFTER_CREATE,
            BEFORE_UPDATE,
            AFTER_UPDATE,
            BEFORE_DELETE,
            AFTER_DELETE;

        }
    }
}

