/*
 * Decompiled with CFR 0.152.
 */
package com.alon.spring.crud.domain.service;

import com.alon.spring.crud.domain.service.SearchType;
import com.alon.spring.specification.ExpressionSpecification;
import com.cosium.spring.data.jpa.entity.graph.domain.DynamicEntityGraph;
import com.cosium.spring.data.jpa.entity.graph.domain.EntityGraph;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;

public class SearchCriteria {
    private Specification filter;
    private Pageable pageable;
    private EntityGraph expand;

    public Specification getFilter() {
        return this.filter;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public EntityGraph getExpand() {
        return this.expand;
    }

    public SearchType getSearchOption() {
        Object option = "";
        if (this.filter != null) {
            option = (String)option + SearchType.FILTER.getOption();
        }
        if (this.expand != null) {
            option = (String)option + SearchType.EXPAND.getOption();
        }
        return SearchType.getByOptionString((String)option);
    }

    public static SearchCriteriaBuilder of() {
        return new SearchCriteriaBuilder();
    }

    public static final class SearchCriteriaBuilder {
        private SearchCriteria searchCriteria = new SearchCriteria();

        private SearchCriteriaBuilder() {
        }

        public SearchCriteriaBuilder filter(Specification filter) {
            this.searchCriteria.filter = filter;
            return this;
        }

        public SearchCriteriaBuilder filter(String filter) {
            this.searchCriteria.filter = ExpressionSpecification.of((String)filter);
            return this;
        }

        public SearchCriteriaBuilder pageable(Pageable pageable) {
            this.searchCriteria.pageable = pageable;
            return this;
        }

        public SearchCriteriaBuilder expand(List<String> expand) {
            if (expand != null && !expand.isEmpty()) {
                this.searchCriteria.expand = new DynamicEntityGraph(expand);
            }
            return this;
        }

        public SearchCriteria build() {
            return this.searchCriteria;
        }
    }
}

